/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.ccr.CrossClusterReplicationHelper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch7.internal.index.CompanyIndexFactory;
import com.liferay.portal.search.elasticsearch7.internal.index.CompanyIndexFactoryHelper;
import com.liferay.portal.search.index.ConcurrentReindexManager;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConcurrentReindexManager.class})
public class CompanyConcurrentReindexManager
implements ConcurrentReindexManager {
    private static final Log _log = LogFactoryUtil.getLog(CompanyConcurrentReindexManager.class);
    private static final Snapshot<CrossClusterReplicationHelper> _crossClusterReplicationHelperSnapshot = new Snapshot(CompanyIndexFactory.class, CrossClusterReplicationHelper.class, null, true);
    @Reference
    private CompanyIndexFactoryHelper _companyIndexFactoryHelper;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    @Reference
    private IndexNameBuilder _indexNameBuilder;

    public void createNextIndex(long companyId) throws Exception {
        if (companyId == 0L) {
            return;
        }
        String baseIndexName = this._indexNameBuilder.getIndexName(companyId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStampSuffix = dateFormat.format(new Date());
        String newIndexName = baseIndexName + "-" + timeStampSuffix;
        RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
        if (this._companyIndexFactoryHelper.hasIndex(restHighLevelClient.indices(), newIndexName)) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Creating next index " + newIndexName));
        }
        this._companyIndexFactoryHelper.createIndex(newIndexName, restHighLevelClient.indices());
        this._companyLocalService.updateIndexNameNext(companyId, newIndexName);
    }

    public void deleteNextIndex(long companyId) {
        Company company = this._companyLocalService.fetchCompany(companyId);
        if (company == null) {
            return;
        }
        String indexName = company.getIndexNameNext();
        if (!Validator.isBlank((String)indexName)) {
            RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deleting next index " + indexName));
            }
            this._companyIndexFactoryHelper.deleteIndex(indexName, restHighLevelClient.indices(), companyId, false);
        }
    }

    public void replaceCurrentIndexWithNextIndex(long companyId) throws Exception {
        if (companyId == 0L) {
            return;
        }
        String baseIndexName = this._indexNameBuilder.getIndexName(companyId);
        Company company = this._companyLocalService.getCompany(companyId);
        RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
        IndicesClient indicesClient = restHighLevelClient.indices();
        CrossClusterReplicationHelper crossClusterReplicationHelper = (CrossClusterReplicationHelper)_crossClusterReplicationHelperSnapshot.get();
        if (crossClusterReplicationHelper != null) {
            if (!Validator.isBlank((String)company.getIndexNameCurrent())) {
                crossClusterReplicationHelper.unfollow(company.getIndexNameCurrent());
            } else {
                crossClusterReplicationHelper.unfollow(baseIndexName);
            }
        }
        this._updateAliases(baseIndexName, company, indicesClient);
        this._companyLocalService.updateIndexNames(companyId, company.getIndexNameNext(), null);
        if (crossClusterReplicationHelper != null) {
            crossClusterReplicationHelper.follow(company.getIndexNameNext());
        }
    }

    private Set<String> _getBaseIndexAliasIndexNames(String baseIndexName, IndicesClient indicesClient) throws Exception {
        HashSet<String> baseIndexAliasIndexNames = new HashSet<String>();
        GetAliasesResponse getAliasesResponse = indicesClient.getAlias(new GetAliasesRequest(new String[]{baseIndexName}), RequestOptions.DEFAULT);
        Map aliases = getAliasesResponse.getAliases();
        if (MapUtil.isNotEmpty((Map)aliases)) {
            baseIndexAliasIndexNames.addAll(aliases.keySet());
        }
        return baseIndexAliasIndexNames;
    }

    private Set<String> _getRemoveIndexNames(String baseIndexName, IndicesClient indicesClient) throws Exception {
        Set<String> removeIndexNames = this._getBaseIndexAliasIndexNames(baseIndexName, indicesClient);
        if (removeIndexNames.isEmpty() && this._companyIndexFactoryHelper.hasIndex(indicesClient, baseIndexName)) {
            removeIndexNames.add(baseIndexName);
        }
        return removeIndexNames;
    }

    private void _updateAliases(String baseIndexName, Company company, IndicesClient indicesClient) throws Exception {
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        Set<String> removeIndexNames = this._getRemoveIndexNames(baseIndexName, indicesClient);
        if (!removeIndexNames.isEmpty()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Removing indexes " + removeIndexNames));
            }
            indicesAliasesRequest.addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX).indices(ArrayUtil.toStringArray(removeIndexNames)));
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Adding alias ", baseIndexName, " for index ", company.getIndexNameNext()}));
        }
        indicesAliasesRequest.addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).alias(baseIndexName).index(company.getIndexNameNext()));
        indicesClient.updateAliases(indicesAliasesRequest, RequestOptions.DEFAULT);
    }
}

