/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationObserver;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.index.IndexNameBuilder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={IndexNameBuilder.class})
public class CompanyIdIndexNameBuilder
implements ElasticsearchConfigurationObserver,
IndexNameBuilder {
    @Reference
    protected ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper;
    private volatile String _indexNamePrefix;

    @Override
    public int compareTo(ElasticsearchConfigurationObserver elasticsearchConfigurationObserver) {
        return this.elasticsearchConfigurationWrapper.compare(this, elasticsearchConfigurationObserver);
    }

    public String getIndexName(long companyId) {
        return this._indexNamePrefix + companyId;
    }

    public String getIndexNamePrefix() {
        return this._indexNamePrefix;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void onElasticsearchConfigurationUpdate() {
        this.setIndexNamePrefix(this.elasticsearchConfigurationWrapper.indexNamePrefix());
    }

    @Activate
    protected void activate() {
        this.elasticsearchConfigurationWrapper.register(this);
        this.setIndexNamePrefix(this.elasticsearchConfigurationWrapper.indexNamePrefix());
    }

    @Deactivate
    protected void deactivate() {
        this.elasticsearchConfigurationWrapper.unregister(this);
    }

    protected void setIndexNamePrefix(String indexNamePrefix) {
        this._indexNamePrefix = indexNamePrefix == null ? "" : StringUtil.toLowerCase((String)StringUtil.trim((String)indexNamePrefix));
    }
}

