/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationObserver;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch7.internal.index.CompanyIndexFactoryHelper;
import com.liferay.portal.search.elasticsearch7.internal.index.IndexFactory;
import com.liferay.portal.search.elasticsearch7.internal.index.util.IndexFactoryCompanyIdRegistryUtil;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.UpdateIndexSettingsIndexRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={IndexFactory.class})
public class CompanyIndexFactory
implements ElasticsearchConfigurationObserver,
IndexFactory {
    private static final Log _log = LogFactoryUtil.getLog(CompanyIndexFactory.class);
    @Reference
    private CompanyIndexFactoryHelper _companyIndexFactoryHelper;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    @Reference
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private SearchEngineAdapter _searchEngineAdapter;

    @Override
    public int compareTo(ElasticsearchConfigurationObserver elasticsearchConfigurationObserver) {
        return this._elasticsearchConfigurationWrapper.compare(this, elasticsearchConfigurationObserver);
    }

    @Override
    public boolean deleteIndex(IndicesClient indicesClient, long companyId) {
        String indexName = this._companyIndexFactoryHelper.getIndexName(companyId);
        Company company = this._companyLocalService.fetchCompany(companyId);
        if (company != null && !Validator.isBlank((String)company.getIndexNameCurrent())) {
            indexName = company.getIndexNameCurrent();
        }
        if (!this._companyIndexFactoryHelper.hasIndex(indicesClient, indexName)) {
            return false;
        }
        this._companyIndexFactoryHelper.deleteIndex(indexName, indicesClient, companyId, true);
        return true;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public boolean initializeIndex(IndicesClient indicesClient, long companyId) {
        String indexName = this._companyIndexFactoryHelper.getIndexName(companyId);
        if (this._companyIndexFactoryHelper.hasIndex(indicesClient, indexName)) {
            return false;
        }
        this._companyIndexFactoryHelper.createIndex(indexName, indicesClient);
        return true;
    }

    @Override
    public void onElasticsearchConfigurationUpdate() {
        this._initializeCompanyIndexes();
        this._updateMaxResultWindow();
    }

    @Override
    public synchronized void registerCompanyId(long companyId) {
        IndexFactoryCompanyIdRegistryUtil.registerCompanyId(companyId);
    }

    @Override
    public synchronized void unregisterCompanyId(long companyId) {
        IndexFactoryCompanyIdRegistryUtil.unregisterCompanyId(companyId);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._elasticsearchConfigurationWrapper.register(this);
        this._initializeCompanyIndexes();
    }

    @Deactivate
    protected void deactivate() {
        this._elasticsearchConfigurationWrapper.unregister(this);
    }

    private synchronized void _initializeCompanyIndexes() {
        long[] lArray = IndexFactoryCompanyIdRegistryUtil.getCompanyIds();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long companyId = lArray[i];
            try {
                RestHighLevelClient restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
                this.initializeIndex(restHighLevelClient.indices(), companyId);
                continue;
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to reinitialize index for company " + companyId), (Throwable)exception);
            }
        }
    }

    private void _updateMaxResultWindow() {
        int maxResultWindow = this._elasticsearchConfigurationWrapper.indexMaxResultWindow();
        long[] lArray = IndexFactoryCompanyIdRegistryUtil.getCompanyIds();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long companyId = lArray[i];
            String indexName = this._indexNameBuilder.getIndexName(companyId.longValue());
            UpdateIndexSettingsIndexRequest updateIndexSettingsIndexRequest = new UpdateIndexSettingsIndexRequest(indexName);
            updateIndexSettingsIndexRequest.setSettings("{\"index.max_result_window\": " + maxResultWindow + "}");
            this._searchEngineAdapter.execute((IndexRequest)updateIndexSettingsIndexRequest);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Updated index.max_result_window to ", maxResultWindow, " for index ", indexName}));
        }
    }
}

