/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.osgi.service.tracker.collections.EagerServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionNotInitializedException;
import com.liferay.portal.search.elasticsearch7.internal.helper.SearchLogHelperUtil;
import com.liferay.portal.search.elasticsearch7.internal.index.LiferayDocumentTypeFactory;
import com.liferay.portal.search.elasticsearch7.internal.index.util.IndexFactoryCompanyIdRegistryUtil;
import com.liferay.portal.search.elasticsearch7.internal.settings.SettingsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.spi.index.configuration.contributor.IndexConfigurationContributor;
import com.liferay.portal.search.spi.index.configuration.contributor.helper.TypeMappingsHelper;
import com.liferay.portal.search.spi.index.listener.CompanyIndexListener;
import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={CompanyIndexFactoryHelper.class})
public class CompanyIndexFactoryHelper {
    private static final Log _log = LogFactoryUtil.getLog(CompanyIndexFactoryHelper.class);
    private ServiceTrackerList<CompanyIndexListener> _companyIndexListenerServiceTrackerList;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    @Reference
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    private ServiceTrackerList<IndexConfigurationContributor> _indexConfigurationContributorServiceTrackerList;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private JSONFactory _jsonFactory;

    public void createIndex(String indexName, IndicesClient indicesClient) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        LiferayDocumentTypeFactory liferayDocumentTypeFactory = new LiferayDocumentTypeFactory(indexName, indicesClient, this._jsonFactory);
        this._setSettings(createIndexRequest, liferayDocumentTypeFactory);
        this._setMappings(createIndexRequest, liferayDocumentTypeFactory);
        try {
            CreateIndexResponse actionResponse = indicesClient.create(createIndexRequest, RequestOptions.DEFAULT);
            SearchLogHelperUtil.logActionResponse(_log, (ActionResponse)actionResponse);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        this._updateLiferayDocumentType(liferayDocumentTypeFactory);
        this._executeCompanyIndexListenersAfterCreate(indexName);
    }

    public void deleteIndex(String indexName, IndicesClient indicesClient, long companyId, boolean resetBothIndexNames) {
        this._executeCompanyIndexListenersBeforeDelete(indexName);
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
        try {
            AcknowledgedResponse actionResponse = indicesClient.delete(deleteIndexRequest, RequestOptions.DEFAULT);
            SearchLogHelperUtil.logActionResponse(_log, (ActionResponse)actionResponse);
            if (companyId != 0L) {
                if (resetBothIndexNames) {
                    this._companyLocalService.updateIndexNames(companyId, null, null);
                } else {
                    this._companyLocalService.updateIndexNameNext(companyId, null);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getIndexName(long companyId) {
        return this._indexNameBuilder.getIndexName(companyId);
    }

    public boolean hasIndex(IndicesClient indicesClient, String indexName) {
        GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{indexName});
        try {
            return indicesClient.exists(getIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._companyIndexListenerServiceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, CompanyIndexListener.class);
        this._indexConfigurationContributorServiceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, IndexConfigurationContributor.class, null, (ServiceTrackerCustomizer)new EagerServiceTrackerCustomizer<IndexConfigurationContributor, IndexConfigurationContributor>(){

            public IndexConfigurationContributor addingService(ServiceReference<IndexConfigurationContributor> serviceReference) {
                IndexConfigurationContributor indexConfigurationContributor = (IndexConfigurationContributor)bundleContext.getService(serviceReference);
                CompanyIndexFactoryHelper.this._processContributions(indexConfigurationContributor);
                return indexConfigurationContributor;
            }

            public void modifiedService(ServiceReference<IndexConfigurationContributor> serviceReference, IndexConfigurationContributor indexConfigurationContributor) {
            }

            public void removedService(ServiceReference<IndexConfigurationContributor> serviceReference, IndexConfigurationContributor indexConfigurationContributor) {
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        if (this._companyIndexListenerServiceTrackerList != null) {
            this._companyIndexListenerServiceTrackerList.close();
        }
        if (this._indexConfigurationContributorServiceTrackerList != null) {
            this._indexConfigurationContributorServiceTrackerList.close();
        }
    }

    private void _executeCompanyIndexListenerAfterCreate(CompanyIndexListener companyIndexListener, String indexName) {
        try {
            companyIndexListener.onAfterCreate(indexName);
        }
        catch (Throwable throwable) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to apply listener ", companyIndexListener, " after creating index ", indexName}), throwable);
        }
    }

    private void _executeCompanyIndexListenerBeforeDelete(CompanyIndexListener companyIndexListener, String indexName) {
        try {
            companyIndexListener.onBeforeDelete(indexName);
        }
        catch (Throwable throwable) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to apply listener ", companyIndexListener, " before deleting index ", indexName}), throwable);
        }
    }

    private void _executeCompanyIndexListenersAfterCreate(String indexName) {
        for (CompanyIndexListener companyIndexListener : this._companyIndexListenerServiceTrackerList) {
            this._executeCompanyIndexListenerAfterCreate(companyIndexListener, indexName);
        }
    }

    private void _executeCompanyIndexListenersBeforeDelete(String indexName) {
        for (CompanyIndexListener companyIndexListener : this._companyIndexListenerServiceTrackerList) {
            this._executeCompanyIndexListenerBeforeDelete(companyIndexListener, indexName);
        }
    }

    private void _loadAdditionalIndexConfigurations(SettingsBuilder settingsBuilder) {
        settingsBuilder.loadFromSource(this._elasticsearchConfigurationWrapper.additionalIndexConfigurations());
    }

    private void _loadDefaultIndexSettings(LiferayDocumentTypeFactory liferayDocumentTypeFactory, SettingsBuilder settingsBuilder) {
        liferayDocumentTypeFactory.loadDefaultAnalyzers(settingsBuilder);
        String defaultIndexSettings = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/settings/index-settings-defaults.json");
        settingsBuilder.loadFromSource(defaultIndexSettings);
    }

    private void _loadIndexConfigurationContributors(SettingsBuilder settingsBuilder) {
        for (IndexConfigurationContributor indexConfigurationContributor : this._indexConfigurationContributorServiceTrackerList) {
            indexConfigurationContributor.contributeSettings(settingsBuilder::put);
        }
    }

    private void _loadIndexConfigurations(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("index.number_of_replicas", this._elasticsearchConfigurationWrapper.indexNumberOfReplicas());
        settingsBuilder.put("index.number_of_shards", this._elasticsearchConfigurationWrapper.indexNumberOfShards());
        settingsBuilder.put("index.max_result_window", String.valueOf(this._elasticsearchConfigurationWrapper.indexMaxResultWindow()));
    }

    private void _loadTestModeIndexSettings(SettingsBuilder settingsBuilder) {
        if (!PortalRunMode.isTestMode()) {
            return;
        }
        settingsBuilder.put("index.refresh_interval", "1ms");
        settingsBuilder.put("index.search.slowlog.threshold.fetch.warn", "-1");
        settingsBuilder.put("index.search.slowlog.threshold.query.warn", "-1");
        settingsBuilder.put("index.translog.sync_interval", "100ms");
    }

    private void _processContributions(IndexConfigurationContributor indexConfigurationContributor) {
        boolean contributeMappings = Validator.isNull((String)this._elasticsearchConfigurationWrapper.overrideTypeMappings());
        SettingsBuilder settingsBuilder = new SettingsBuilder(Settings.builder());
        indexConfigurationContributor.contributeSettings(settingsBuilder::put);
        Settings settings = settingsBuilder.build();
        if (!contributeMappings && settings.isEmpty()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No mappings or settings to contribute from " + indexConfigurationContributor));
            }
            return;
        }
        RestHighLevelClient restHighLevelClient = null;
        try {
            restHighLevelClient = this._elasticsearchConnectionManager.getRestHighLevelClient();
        }
        catch (ElasticsearchConnectionNotInitializedException elasticsearchConnectionNotInitializedException) {
            _log.error((Throwable)elasticsearchConnectionNotInitializedException);
            return;
        }
        IndicesClient indicesClient = restHighLevelClient.indices();
        this._companyLocalService.forEachCompanyId(companyId -> {
            String indexName = this.getIndexName((long)companyId);
            if (!settings.isEmpty()) {
                UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(new String[]{indexName});
                updateSettingsRequest.settings(settings);
                try {
                    indicesClient.putSettings(updateSettingsRequest, RequestOptions.DEFAULT);
                }
                catch (Exception exception) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to put settings for index ", indexName, " with contributor ", indexConfigurationContributor}), (Throwable)exception);
                }
            }
            if (contributeMappings) {
                indexConfigurationContributor.contributeMappings((TypeMappingsHelper)new LiferayDocumentTypeFactory(indexName, indicesClient, this._jsonFactory));
            }
        }, IndexFactoryCompanyIdRegistryUtil.getCompanyIds());
    }

    private void _putAdditionalTypeMappings(LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        if (Validator.isNull((String)this._elasticsearchConfigurationWrapper.additionalTypeMappings())) {
            return;
        }
        liferayDocumentTypeFactory.putTypeMappings(this._elasticsearchConfigurationWrapper.additionalTypeMappings());
    }

    private void _putContributedTypeMappings(LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        for (IndexConfigurationContributor indexConfigurationContributor : this._indexConfigurationContributorServiceTrackerList) {
            indexConfigurationContributor.contributeMappings((TypeMappingsHelper)liferayDocumentTypeFactory);
        }
    }

    private void _setMappings(CreateIndexRequest createIndexRequest, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        liferayDocumentTypeFactory.setMappings(createIndexRequest, this._elasticsearchConfigurationWrapper.overrideTypeMappings());
    }

    private void _setSettings(CreateIndexRequest createIndexRequest, LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        SettingsBuilder settingsBuilder = new SettingsBuilder(Settings.builder());
        this._loadDefaultIndexSettings(liferayDocumentTypeFactory, settingsBuilder);
        this._loadTestModeIndexSettings(settingsBuilder);
        this._loadIndexConfigurations(settingsBuilder);
        this._loadAdditionalIndexConfigurations(settingsBuilder);
        this._loadIndexConfigurationContributors(settingsBuilder);
        if (Validator.isNotNull((String)settingsBuilder.get("index.number_of_replicas"))) {
            settingsBuilder.put("index.auto_expand_replicas", false);
        }
        createIndexRequest.settings(settingsBuilder.getBuilder());
    }

    private void _updateLiferayDocumentType(LiferayDocumentTypeFactory liferayDocumentTypeFactory) {
        if (Validator.isNotNull((String)this._elasticsearchConfigurationWrapper.overrideTypeMappings())) {
            return;
        }
        this._putAdditionalTypeMappings(liferayDocumentTypeFactory);
        this._putContributedTypeMappings(liferayDocumentTypeFactory);
        liferayDocumentTypeFactory.putDefaultTypeMappingTemplate();
    }
}

