/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.helper.SearchLogHelperUtil;
import com.liferay.portal.search.elasticsearch7.internal.settings.SettingsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.search.spi.index.configuration.contributor.helper.TypeMappingsHelper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.xcontent.XContentType;

public class LiferayDocumentTypeFactory
implements TypeMappingsHelper {
    private static final Log _log = LogFactoryUtil.getLog(LiferayDocumentTypeFactory.class);
    private final String _indexName;
    private final IndicesClient _indicesClient;
    private final JSONFactory _jsonFactory;

    public LiferayDocumentTypeFactory(String indexName, IndicesClient indicesClient, JSONFactory jsonFactory) {
        this._indexName = indexName;
        this._indicesClient = indicesClient;
        this._jsonFactory = jsonFactory;
    }

    public void loadDefaultAnalyzers(SettingsBuilder settingsBuilder) {
        String defaultAnalyzers = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/settings/index-settings.json");
        settingsBuilder.loadFromSource(defaultAnalyzers);
    }

    public void putDefaultTypeMappingTemplate() {
        String name = StringUtil.replace((String)"/META-INF/mappings/liferay-type-mappings.json", (String)".json", (String)"-default-template.json");
        String defaultTypeMappingTemplate = ResourceUtil.getResourceAsString(this.getClass(), name);
        this.putTypeMappings(defaultTypeMappingTemplate);
    }

    public void putTypeMappings(String source) {
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{this._indexName});
        putMappingRequest.source(this._mergeDynamicTemplates(source, this._indexName), XContentType.JSON);
        try {
            AcknowledgedResponse actionResponse = this._indicesClient.putMapping(putMappingRequest, RequestOptions.DEFAULT);
            SearchLogHelperUtil.logActionResponse(_log, (ActionResponse)actionResponse);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public void setMappings(CreateIndexRequest createIndexRequest) {
        this.setMappings(createIndexRequest, null);
    }

    public void setMappings(CreateIndexRequest createIndexRequest, String mappings) {
        JSONObject mappingsJSONObject;
        if (Validator.isNull((String)mappings)) {
            mappings = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/mappings/liferay-type-mappings.json");
        }
        if ((mappingsJSONObject = this.createJSONObject(mappings)).has("LiferayDocumentType")) {
            mappingsJSONObject = mappingsJSONObject.getJSONObject("LiferayDocumentType");
        }
        createIndexRequest.mapping(mappingsJSONObject.toString(), XContentType.JSON);
    }

    protected JSONObject createJSONObject(String mappings) {
        try {
            return this._jsonFactory.createJSONObject(mappings);
        }
        catch (JSONException jsonException) {
            throw new RuntimeException(jsonException);
        }
    }

    protected String getMappings(String indexName) {
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(new String[]{indexName});
        GetMappingsResponse getMappingsResponse = null;
        try {
            getMappingsResponse = this._indicesClient.getMapping(getMappingsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        Map mappings = getMappingsResponse.mappings();
        MappingMetadata mappingMetadata = (MappingMetadata)mappings.get(indexName);
        CompressedXContent compressedXContent = mappingMetadata.source();
        return compressedXContent.toString();
    }

    private JSONArray _merge(JSONArray jsonArray1, JSONArray jsonArray2) {
        LinkedHashMap<String, JSONObject> linkedHashMap = new LinkedHashMap<String, JSONObject>();
        this._putAll(linkedHashMap, jsonArray1);
        this._putAll(linkedHashMap, jsonArray2);
        JSONArray jsonArray3 = this._jsonFactory.createJSONArray();
        JSONObject defaultTemplateJSONObject = null;
        for (Map.Entry<String, JSONObject> entry : linkedHashMap.entrySet()) {
            String key = entry.getKey();
            if (key.equals("template_")) {
                defaultTemplateJSONObject = entry.getValue();
                continue;
            }
            jsonArray3.put(entry.getValue());
        }
        if (defaultTemplateJSONObject != null) {
            jsonArray3.put(defaultTemplateJSONObject);
        }
        return jsonArray3;
    }

    private String _mergeDynamicTemplates(String source, String indexName) {
        JSONObject mappingsJSONObject;
        JSONArray sourceTypeTemplatesJSONArray;
        JSONObject sourceJSONObject;
        JSONObject sourceTypeJSONObject = sourceJSONObject = this.createJSONObject(source);
        if (sourceJSONObject.has("LiferayDocumentType")) {
            sourceTypeJSONObject = sourceJSONObject.getJSONObject("LiferayDocumentType");
        }
        if ((sourceTypeTemplatesJSONArray = sourceTypeJSONObject.getJSONArray("dynamic_templates")) == null) {
            return this._removeLegacyDocumentType(sourceJSONObject);
        }
        JSONObject mappingsTypeJSONObject = mappingsJSONObject = this.createJSONObject(this.getMappings(indexName));
        if (mappingsJSONObject.has("LiferayDocumentType")) {
            mappingsTypeJSONObject = mappingsJSONObject.getJSONObject("LiferayDocumentType");
        }
        JSONArray typeTemplatesJSONArray = mappingsTypeJSONObject.getJSONArray("dynamic_templates");
        sourceTypeJSONObject.put("dynamic_templates", this._merge(typeTemplatesJSONArray, sourceTypeTemplatesJSONArray));
        return this._removeLegacyDocumentType(sourceJSONObject);
    }

    private void _putAll(Map<String, JSONObject> map, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray namesJSONArray = jsonObject.names();
            String name = (String)namesJSONArray.get(0);
            map.put(name, jsonObject);
        }
    }

    private String _removeLegacyDocumentType(JSONObject sourceJSONObject) {
        if (sourceJSONObject.has("LiferayDocumentType")) {
            sourceJSONObject = sourceJSONObject.getJSONObject("LiferayDocumentType");
        }
        return sourceJSONObject.toString();
    }
}

