/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.index;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.index.SyncReindexManager;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.DateRangeTermQuery;
import com.liferay.portal.search.query.ExistsQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermsQuery;
import java.text.Format;
import java.util.Date;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SyncReindexManager.class})
public class SyncReindexManagerImpl
implements SyncReindexManager {
    private static final Log _log = LogFactoryUtil.getLog(SyncReindexManagerImpl.class);
    @Reference
    private FastDateFormatFactory _fastDateFormatFactory;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference
    private SearchEngineAdapter _searchEngineAdapter;

    public void deleteStaleDocuments(long companyId, Date date, Set<String> classNames) {
        this.deleteStaleDocuments(this._indexNameBuilder.getIndexName(companyId), date, classNames);
    }

    public void deleteStaleDocuments(String indexName, Date date, Set<String> classNames) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deleting stale documents in index " + indexName));
        }
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        if (SetUtil.isNotEmpty(classNames)) {
            TermsQuery termsQuery = this._queries.terms("entryClassName");
            termsQuery.addValues(classNames.toArray());
            booleanQuery.addFilterQueryClauses(new Query[]{termsQuery});
        }
        BooleanQuery timestampBooleanQuery = this._queries.booleanQuery();
        Format format = this._fastDateFormatFactory.getSimpleDateFormat("yyyyMMddHHmmss");
        DateRangeTermQuery dateRangeTermQuery = this._queries.dateRangeTerm("timestamp", false, false, null, format.format(date));
        timestampBooleanQuery.addShouldQueryClauses(new Query[]{dateRangeTermQuery});
        BooleanQuery existsBooleanQuery = this._queries.booleanQuery();
        ExistsQuery existsQuery = this._queries.exists("timestamp");
        existsBooleanQuery.addMustNotQueryClauses(new Query[]{existsQuery});
        timestampBooleanQuery.addShouldQueryClauses(new Query[]{existsBooleanQuery});
        booleanQuery.addFilterQueryClauses(new Query[]{timestampBooleanQuery});
        DeleteByQueryDocumentRequest deleteByQueryDocumentRequest = new DeleteByQueryDocumentRequest((Query)booleanQuery, new String[]{indexName});
        this._searchEngineAdapter.execute((DocumentRequest)deleteByQueryDocumentRequest);
    }
}

