/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.portal.search.elasticsearch7.internal.query.DateRangeTermQueryTranslator;
import com.liferay.portal.search.query.DateRangeTermQuery;
import java.util.TimeZone;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={DateRangeTermQueryTranslator.class})
public class DateRangeTermQueryTranslatorImpl
implements DateRangeTermQueryTranslator {
    @Override
    public QueryBuilder translate(DateRangeTermQuery dateRangeTermQuery) {
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)dateRangeTermQuery.getField());
        if (dateRangeTermQuery.getDateFormat() != null) {
            rangeQueryBuilder.format(dateRangeTermQuery.getDateFormat());
        }
        rangeQueryBuilder.from(dateRangeTermQuery.getLowerBound());
        rangeQueryBuilder.includeLower(dateRangeTermQuery.isIncludesLower());
        rangeQueryBuilder.includeUpper(dateRangeTermQuery.isIncludesUpper());
        TimeZone timeZone = dateRangeTermQuery.getTimeZone();
        if (timeZone != null) {
            rangeQueryBuilder.timeZone(timeZone.getID());
        }
        rangeQueryBuilder.to(dateRangeTermQuery.getUpperBound());
        return rangeQueryBuilder;
    }
}

