/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.search.elasticsearch7.internal.query.CombineFunctionTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.FunctionScoreQueryTranslator;
import com.liferay.portal.search.elasticsearch7.internal.query.function.score.ElasticsearchScoreFunctionTranslator;
import com.liferay.portal.search.query.FunctionScoreQuery;
import com.liferay.portal.search.query.QueryTranslator;
import com.liferay.portal.search.query.function.score.ScoreFunction;
import com.liferay.portal.search.query.function.score.ScoreFunctionTranslator;
import java.util.Collection;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={FunctionScoreQueryTranslator.class})
public class FunctionScoreQueryTranslatorImpl
implements FunctionScoreQueryTranslator {
    private final CombineFunctionTranslator _combineFunctionTranslator = new CombineFunctionTranslator();
    private final ScoreFunctionTranslator<ScoreFunctionBuilder<?>> _scoreFunctionTranslator = new ElasticsearchScoreFunctionTranslator();

    @Override
    public QueryBuilder translate(FunctionScoreQuery functionScoreQuery, QueryTranslator<QueryBuilder> queryTranslator) {
        QueryBuilder queryBuilder = (QueryBuilder)queryTranslator.translate(functionScoreQuery.getQuery());
        FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])((FunctionScoreQueryBuilder.FilterFunctionBuilder[])TransformUtil.transformToArray((Collection)functionScoreQuery.getFilterQueryScoreFunctionHolders(), filterQueryScoreFunctionHolder -> this._translateFilterFunction((FunctionScoreQuery.FilterQueryScoreFunctionHolder)filterQueryScoreFunctionHolder, queryTranslator, this._translateScoreFunction(filterQueryScoreFunctionHolder.getScoreFunction())), FunctionScoreQueryBuilder.FilterFunctionBuilder.class)));
        if (functionScoreQuery.getMinScore() != null) {
            functionScoreQueryBuilder.setMinScore(functionScoreQuery.getMinScore().floatValue());
        }
        if (functionScoreQuery.getMaxBoost() != null) {
            functionScoreQueryBuilder.maxBoost(functionScoreQuery.getMaxBoost().floatValue());
        }
        if (functionScoreQuery.getScoreMode() != null) {
            functionScoreQueryBuilder.scoreMode(this.translate(functionScoreQuery.getScoreMode()));
        }
        if (functionScoreQuery.getCombineFunction() != null) {
            functionScoreQueryBuilder.boostMode(this._combineFunctionTranslator.translate(functionScoreQuery.getCombineFunction()));
        }
        return functionScoreQueryBuilder;
    }

    protected FunctionScoreQuery.ScoreMode translate(FunctionScoreQuery.ScoreMode scoreMode) {
        if (scoreMode == FunctionScoreQuery.ScoreMode.AVG) {
            return FunctionScoreQuery.ScoreMode.AVG;
        }
        if (scoreMode == FunctionScoreQuery.ScoreMode.FIRST) {
            return FunctionScoreQuery.ScoreMode.FIRST;
        }
        if (scoreMode == FunctionScoreQuery.ScoreMode.MAX) {
            return FunctionScoreQuery.ScoreMode.MAX;
        }
        if (scoreMode == FunctionScoreQuery.ScoreMode.MIN) {
            return FunctionScoreQuery.ScoreMode.MIN;
        }
        if (scoreMode == FunctionScoreQuery.ScoreMode.MULTIPLY) {
            return FunctionScoreQuery.ScoreMode.MULTIPLY;
        }
        if (scoreMode == FunctionScoreQuery.ScoreMode.SUM) {
            return FunctionScoreQuery.ScoreMode.SUM;
        }
        throw new IllegalArgumentException("Invalid FunctionScoreQuery.ScoreMode: " + scoreMode);
    }

    private FunctionScoreQueryBuilder.FilterFunctionBuilder _translateFilterFunction(FunctionScoreQuery.FilterQueryScoreFunctionHolder filterQueryScoreFunctionHolder, QueryTranslator<QueryBuilder> queryTranslator, ScoreFunctionBuilder<?> scoreFunctionBuilder) {
        if (filterQueryScoreFunctionHolder.getFilterQuery() == null) {
            return new FunctionScoreQueryBuilder.FilterFunctionBuilder(scoreFunctionBuilder);
        }
        return new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)queryTranslator.translate(filterQueryScoreFunctionHolder.getFilterQuery()), scoreFunctionBuilder);
    }

    private ScoreFunctionBuilder<?> _translateScoreFunction(ScoreFunction scoreFunction) {
        ScoreFunctionBuilder scoreFunctionBuilder = (ScoreFunctionBuilder)scoreFunction.accept(this._scoreFunctionTranslator);
        if (scoreFunction.getWeight() != null) {
            scoreFunctionBuilder.setWeight(scoreFunction.getWeight().floatValue());
        }
        return scoreFunctionBuilder;
    }
}

