/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.portal.search.elasticsearch7.internal.query.FuzzyQueryTranslator;
import com.liferay.portal.search.query.FuzzyQuery;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;

@Component(service={FuzzyQueryTranslator.class})
public class FuzzyQueryTranslatorImpl
implements FuzzyQueryTranslator {
    @Override
    public QueryBuilder translate(FuzzyQuery fuzzyQuery) {
        FuzzyQueryBuilder fuzzyQueryBuilder = QueryBuilders.fuzzyQuery((String)fuzzyQuery.getField(), (String)fuzzyQuery.getValue());
        if (fuzzyQuery.getFuzziness() != null) {
            fuzzyQueryBuilder.fuzziness(Fuzziness.build((Object)fuzzyQuery.getFuzziness()));
        }
        if (fuzzyQuery.getMaxExpansions() != null) {
            fuzzyQueryBuilder.maxExpansions(fuzzyQuery.getMaxExpansions().intValue());
        }
        if (fuzzyQuery.getPrefixLength() != null) {
            fuzzyQueryBuilder.prefixLength(fuzzyQuery.getPrefixLength().intValue());
        }
        if (fuzzyQuery.getRewrite() != null) {
            fuzzyQueryBuilder.rewrite(fuzzyQuery.getRewrite());
        }
        if (fuzzyQuery.getTranspositions() != null) {
            fuzzyQueryBuilder.transpositions(fuzzyQuery.getTranspositions().booleanValue());
        }
        return fuzzyQueryBuilder;
    }
}

