/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.query;

import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.query.MoreLikeThisQueryTranslator;
import com.liferay.portal.search.query.MoreLikeThisQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;

@Component(service={MoreLikeThisQueryTranslator.class})
public class MoreLikeThisQueryTranslatorImpl
implements MoreLikeThisQueryTranslator {
    @Override
    public QueryBuilder translate(MoreLikeThisQuery moreLikeThisQuery) {
        Set stopWords;
        ArrayList likeItems = new ArrayList();
        if (SetUtil.isNotEmpty((Set)moreLikeThisQuery.getDocumentIdentifiers())) {
            Set documentIdentifiers = moreLikeThisQuery.getDocumentIdentifiers();
            documentIdentifiers.forEach(documentIdentifier -> {
                String type = documentIdentifier.getType();
                if (Validator.isNull((String)type)) {
                    type = moreLikeThisQuery.getType();
                }
                if (Validator.isNull((String)type)) {
                    type = "_doc";
                }
                MoreLikeThisQueryBuilder.Item moreLikeThisQueryBuilderItem = new MoreLikeThisQueryBuilder.Item(documentIdentifier.getIndex(), type, documentIdentifier.getId());
                likeItems.add(moreLikeThisQueryBuilderItem);
            });
        }
        List fields = moreLikeThisQuery.getFields();
        String[] fieldsArray = null;
        if (!fields.isEmpty()) {
            fieldsArray = fields.toArray(new String[0]);
        }
        List likeTexts = moreLikeThisQuery.getLikeTexts();
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((String[])fieldsArray, (String[])likeTexts.toArray(new String[0]), (MoreLikeThisQueryBuilder.Item[])likeItems.toArray(new MoreLikeThisQueryBuilder.Item[0]));
        if (Validator.isNotNull((String)moreLikeThisQuery.getAnalyzer())) {
            moreLikeThisQueryBuilder.analyzer(moreLikeThisQuery.getAnalyzer());
        }
        if (moreLikeThisQuery.getMaxDocFrequency() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(moreLikeThisQuery.getMaxDocFrequency().intValue());
        }
        if (moreLikeThisQuery.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(moreLikeThisQuery.getMaxQueryTerms().intValue());
        }
        if (moreLikeThisQuery.getMaxWordLength() != null) {
            moreLikeThisQueryBuilder.maxWordLength(moreLikeThisQuery.getMaxWordLength().intValue());
        }
        if (moreLikeThisQuery.getMinDocFrequency() != null) {
            moreLikeThisQueryBuilder.minDocFreq(moreLikeThisQuery.getMinDocFrequency().intValue());
        }
        if (Validator.isNotNull((String)moreLikeThisQuery.getMinShouldMatch())) {
            moreLikeThisQueryBuilder.minimumShouldMatch(moreLikeThisQuery.getMinShouldMatch());
        }
        if (moreLikeThisQuery.getMinTermFrequency() != null) {
            moreLikeThisQueryBuilder.minTermFreq(moreLikeThisQuery.getMinTermFrequency().intValue());
        }
        if (moreLikeThisQuery.getMinWordLength() != null) {
            moreLikeThisQueryBuilder.minWordLength(moreLikeThisQuery.getMinWordLength().intValue());
        }
        if (!(stopWords = moreLikeThisQuery.getStopWords()).isEmpty()) {
            moreLikeThisQueryBuilder.stopWords(stopWords.toArray(new String[0]));
        }
        if (moreLikeThisQuery.getTermBoost() != null) {
            moreLikeThisQueryBuilder.boostTerms(moreLikeThisQuery.getTermBoost().floatValue());
        }
        if (moreLikeThisQuery.isIncludeInput() != null) {
            moreLikeThisQueryBuilder.include(moreLikeThisQuery.isIncludeInput().booleanValue());
        }
        return moreLikeThisQueryBuilder;
    }
}

