/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document;

import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.document.DocumentFieldsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.ElasticsearchBulkableDocumentRequestTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.document.GetDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.GetDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.GetDocumentResponse;
import com.liferay.portal.search.geolocation.GeoBuilders;
import java.io.IOException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetDocumentRequestExecutor.class})
public class GetDocumentRequestExecutorImpl
implements GetDocumentRequestExecutor {
    @Reference
    private DocumentBuilderFactory _documentBuilderFactory;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    private ElasticsearchBulkableDocumentRequestTranslator _elasticsearchBulkableDocumentRequestTranslator;
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private GeoBuilders _geoBuilders;

    @Override
    public GetDocumentResponse execute(GetDocumentRequest getDocumentRequest) {
        GetRequest getRequest = this._elasticsearchBulkableDocumentRequestTranslator.translate(getDocumentRequest);
        GetResponse getResponse = this._getGetResponse(getRequest, getDocumentRequest);
        GetDocumentResponse getDocumentResponse = new GetDocumentResponse(getResponse.isExists());
        if (!getResponse.isExists()) {
            return getDocumentResponse;
        }
        getDocumentResponse.setSource(getResponse.getSourceAsString());
        getDocumentResponse.setVersion(getResponse.getVersion());
        DocumentFieldsTranslator documentFieldsTranslator = new DocumentFieldsTranslator(this._geoBuilders);
        DocumentBuilder documentBuilder = this._documentBuilderFactory.builder();
        documentFieldsTranslator.translate(documentBuilder, getResponse.getSourceAsMap());
        getDocumentResponse.setDocument(documentBuilder.build());
        return getDocumentResponse;
    }

    private GetResponse _getGetResponse(GetRequest getRequest, GetDocumentRequest getDocumentRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(getDocumentRequest.getConnectionId(), getDocumentRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.get(getRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

