/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.helper.SearchLogHelperUtil;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.CreateIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.util.ClassLoaderUtil;
import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CreateIndexRequestExecutor.class})
public class CreateIndexRequestExecutorImpl
implements CreateIndexRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(CreateIndexRequestExecutorImpl.class);
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public com.liferay.portal.search.engine.adapter.index.CreateIndexResponse execute(com.liferay.portal.search.engine.adapter.index.CreateIndexRequest createIndexRequest) {
        CreateIndexRequest elasticsearchCreateIndexRequest = this.createCreateIndexRequest(createIndexRequest);
        CreateIndexResponse elasticsearchCreateIndexResponse = this._getCreateIndexResponse(elasticsearchCreateIndexRequest, createIndexRequest);
        SearchLogHelperUtil.logActionResponse(_log, (ActionResponse)elasticsearchCreateIndexResponse);
        return new com.liferay.portal.search.engine.adapter.index.CreateIndexResponse(elasticsearchCreateIndexResponse.isAcknowledged(), elasticsearchCreateIndexResponse.index());
    }

    protected CreateIndexRequest createCreateIndexRequest(com.liferay.portal.search.engine.adapter.index.CreateIndexRequest createIndexRequest) {
        CreateIndexRequest elasticsearchCreateIndexRequest = new CreateIndexRequest(createIndexRequest.getIndexName());
        if (createIndexRequest.getMappings() != null) {
            ClassLoaderUtil.getWithContextClassLoader(() -> elasticsearchCreateIndexRequest.mapping(createIndexRequest.getMappings(), XContentType.JSON), this.getClass());
        }
        if (createIndexRequest.getSettings() != null) {
            ClassLoaderUtil.getWithContextClassLoader(() -> elasticsearchCreateIndexRequest.settings(createIndexRequest.getSettings(), XContentType.JSON), this.getClass());
        }
        if (createIndexRequest.getSource() != null) {
            ClassLoaderUtil.getWithContextClassLoader(() -> elasticsearchCreateIndexRequest.source(createIndexRequest.getSource(), XContentType.JSON), this.getClass());
        }
        return elasticsearchCreateIndexRequest;
    }

    private CreateIndexResponse _getCreateIndexResponse(CreateIndexRequest elasticsearchCreateIndexRequest, com.liferay.portal.search.engine.adapter.index.CreateIndexRequest createIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(createIndexRequest.getConnectionId(), createIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.create(elasticsearchCreateIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

