/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.FlushIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndexRequestShardFailureTranslator;
import com.liferay.portal.search.engine.adapter.index.FlushIndexRequest;
import com.liferay.portal.search.engine.adapter.index.FlushIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequestShardFailure;
import java.io.IOException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FlushIndexRequestExecutor.class})
public class FlushIndexRequestExecutorImpl
implements FlushIndexRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private IndexRequestShardFailureTranslator _indexRequestShardFailureTranslator;

    @Override
    public FlushIndexResponse execute(FlushIndexRequest flushIndexRequest) {
        FlushRequest flushRequest = this.createFlushRequest(flushIndexRequest);
        FlushResponse flushResponse = this._getFlushResponse(flushRequest, flushIndexRequest);
        FlushIndexResponse flushIndexResponse = new FlushIndexResponse();
        flushIndexResponse.setFailedShards(flushResponse.getFailedShards());
        flushIndexResponse.setSuccessfulShards(flushResponse.getSuccessfulShards());
        flushIndexResponse.setTotalShards(flushResponse.getTotalShards());
        RestStatus restStatus = flushResponse.getStatus();
        flushIndexResponse.setRestStatus(restStatus.getStatus());
        Object[] shardOperationFailedExceptions = flushResponse.getShardFailures();
        if (ArrayUtil.isNotEmpty((Object[])shardOperationFailedExceptions)) {
            for (Object shardOperationFailedException : shardOperationFailedExceptions) {
                IndexRequestShardFailure indexRequestShardFailure = this._indexRequestShardFailureTranslator.translate((ShardOperationFailedException)shardOperationFailedException);
                flushIndexResponse.addIndexRequestShardFailure(indexRequestShardFailure);
            }
        }
        return flushIndexResponse;
    }

    protected FlushRequest createFlushRequest(FlushIndexRequest flushIndexRequest) {
        FlushRequest flushRequest = new FlushRequest(new String[0]);
        flushRequest.force(flushIndexRequest.isForce());
        flushRequest.indices(flushIndexRequest.getIndexNames());
        flushRequest.waitIfOngoing(flushIndexRequest.isWaitIfOngoing());
        return flushRequest;
    }

    private FlushResponse _getFlushResponse(FlushRequest flushRequest, FlushIndexRequest flushIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(flushIndexRequest.getConnectionId(), flushIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.flush(flushRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

