/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.GetFieldMappingIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.GetFieldMappingIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetFieldMappingIndexResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetFieldMappingsRequest;
import org.elasticsearch.client.indices.GetFieldMappingsResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetFieldMappingIndexRequestExecutor.class})
public class GetFieldMappingIndexRequestExecutorImpl
implements GetFieldMappingIndexRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private JSONFactory _jsonFactory;

    @Override
    public GetFieldMappingIndexResponse execute(GetFieldMappingIndexRequest getFieldMappingIndexRequest) {
        GetFieldMappingsRequest getFieldMappingsRequest = this.createGetFieldMappingsRequest(getFieldMappingIndexRequest);
        GetFieldMappingsResponse getFieldMappingsResponse = this._getGetFieldMappingsResponse(getFieldMappingsRequest, getFieldMappingIndexRequest);
        Map mappings = getFieldMappingsResponse.mappings();
        HashMap<String, String> fieldMappings = new HashMap<String, String>();
        for (String indexName : getFieldMappingIndexRequest.getIndexNames()) {
            Map map = (Map)mappings.get(indexName);
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            for (String fieldName : getFieldMappingIndexRequest.getFields()) {
                GetFieldMappingsResponse.FieldMappingMetadata fieldMappingMetadata = (GetFieldMappingsResponse.FieldMappingMetadata)map.get(fieldName);
                Map source = fieldMappingMetadata.sourceAsMap();
                jsonObject.put(fieldName, (Object)source);
            }
            fieldMappings.put(indexName, jsonObject.toString());
        }
        return new GetFieldMappingIndexResponse(fieldMappings);
    }

    protected GetFieldMappingsRequest createGetFieldMappingsRequest(GetFieldMappingIndexRequest getFieldMappingIndexRequest) {
        GetFieldMappingsRequest getFieldMappingsRequest = new GetFieldMappingsRequest();
        getFieldMappingsRequest.fields(getFieldMappingIndexRequest.getFields());
        getFieldMappingsRequest.indices(getFieldMappingIndexRequest.getIndexNames());
        return getFieldMappingsRequest;
    }

    private GetFieldMappingsResponse _getGetFieldMappingsResponse(GetFieldMappingsRequest getFieldMappingsRequest, GetFieldMappingIndexRequest getFieldMappingIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(getFieldMappingIndexRequest.getConnectionId(), getFieldMappingIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.getFieldMapping(getFieldMappingsRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

