/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.OpenIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesOptions;
import com.liferay.portal.search.engine.adapter.index.OpenIndexResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenIndexRequestExecutor.class})
public class OpenIndexRequestExecutorImpl
implements OpenIndexRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private IndicesOptionsTranslator _indicesOptionsTranslator;

    @Override
    public OpenIndexResponse execute(com.liferay.portal.search.engine.adapter.index.OpenIndexRequest openIndexRequest) {
        OpenIndexRequest elasticsearchOpenIndexRequest = this.createOpenIndexRequest(openIndexRequest);
        AcknowledgedResponse acknowledgedResponse = this.getAcknowledgedResponse(elasticsearchOpenIndexRequest, openIndexRequest);
        return new OpenIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected OpenIndexRequest createOpenIndexRequest(com.liferay.portal.search.engine.adapter.index.OpenIndexRequest openIndexRequest) {
        OpenIndexRequest elasticsearchOpenIndexRequest = new OpenIndexRequest();
        elasticsearchOpenIndexRequest.indices(openIndexRequest.getIndexNames());
        IndicesOptions indicesOptions = openIndexRequest.getIndicesOptions();
        if (indicesOptions != null) {
            elasticsearchOpenIndexRequest.indicesOptions(this._indicesOptionsTranslator.translate(indicesOptions));
        }
        if (openIndexRequest.getTimeout() > 0L) {
            TimeValue timeValue = TimeValue.timeValueMillis((long)openIndexRequest.getTimeout());
            elasticsearchOpenIndexRequest.masterNodeTimeout(timeValue);
            elasticsearchOpenIndexRequest.timeout(timeValue);
        }
        if (openIndexRequest.getWaitForActiveShards() > 0) {
            elasticsearchOpenIndexRequest.waitForActiveShards(openIndexRequest.getWaitForActiveShards());
        }
        return elasticsearchOpenIndexRequest;
    }

    protected AcknowledgedResponse getAcknowledgedResponse(OpenIndexRequest elasticsearchOpenIndexRequest, com.liferay.portal.search.engine.adapter.index.OpenIndexRequest openIndexRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(openIndexRequest.getConnectionId(), openIndexRequest.isPreferLocalCluster());
        IndicesClient indicesClient = restHighLevelClient.indices();
        try {
            return indicesClient.open(elasticsearchOpenIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

