/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.index.StatsIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.StatsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.StatsIndexResponse;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StatsIndexRequestExecutor.class})
public class StatsIndexRequestExecutorImpl
implements StatsIndexRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    @Reference
    private JSONFactory _jsonFactory;

    @Override
    public StatsIndexResponse execute(StatsIndexRequest statsIndexRequest) {
        Request request = this.getElasticsearchIndexRequest(statsIndexRequest);
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(statsIndexRequest.getConnectionId(), statsIndexRequest.isPreferLocalCluster());
        RestClient restClient = restHighLevelClient.getLowLevelClient();
        try {
            Response response = restClient.performRequest(request);
            JSONObject responseJSONObject = this._jsonFactory.createJSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
            JSONObject indicesJSONObject = responseJSONObject.getJSONObject("indices");
            HashMap<String, Long> indexSizes = new HashMap<String, Long>();
            long sizeOfLargestIndex = 0L;
            for (String indexName : indicesJSONObject.keySet()) {
                JSONObject indexJSONObject = indicesJSONObject.getJSONObject(indexName);
                JSONObject totalJSONObject = indexJSONObject.getJSONObject("total");
                JSONObject storeJSONObject = totalJSONObject.getJSONObject("store");
                long indexSize = storeJSONObject.getLong("size_in_bytes");
                if (indexSize > sizeOfLargestIndex) {
                    sizeOfLargestIndex = indexSize;
                }
                indexSizes.put(indexName, indexSize);
            }
            return new StatsIndexResponse(indexSizes, sizeOfLargestIndex);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    protected Request getElasticsearchIndexRequest(StatsIndexRequest statsIndexRequest) {
        String indexes = "_all";
        if (ArrayUtil.isNotEmpty((Object[])statsIndexRequest.getIndexNames())) {
            indexes = StringUtil.merge((Object[])statsIndexRequest.getIndexNames());
        }
        String endpoint = "/" + indexes + "/_stats";
        return new Request("GET", endpoint);
    }
}

