/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.ClearScrollRequestExecutor;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ClearScrollRequestExecutor.class})
public class ClearScrollRequestExecutorImpl
implements ClearScrollRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public com.liferay.portal.search.engine.adapter.search.ClearScrollResponse execute(com.liferay.portal.search.engine.adapter.search.ClearScrollRequest clearScrollRequest) {
        ClearScrollRequest elasticsearchClearScrollRequest = this.createClearScrollRequest(clearScrollRequest);
        ClearScrollResponse clearScrollResponse = this.getClearScrollResponse(clearScrollRequest, elasticsearchClearScrollRequest);
        return new com.liferay.portal.search.engine.adapter.search.ClearScrollResponse(clearScrollResponse.getNumFreed());
    }

    protected ClearScrollRequest createClearScrollRequest(com.liferay.portal.search.engine.adapter.search.ClearScrollRequest clearScrollRequest) {
        ClearScrollRequest elasticsearchClearScrollRequest = new ClearScrollRequest();
        elasticsearchClearScrollRequest.addScrollId(clearScrollRequest.getScrollId());
        return elasticsearchClearScrollRequest;
    }

    protected ClearScrollResponse getClearScrollResponse(com.liferay.portal.search.engine.adapter.search.ClearScrollRequest clearScrollRequest, ClearScrollRequest elasticsearchClearScrollRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(clearScrollRequest.getConnectionId(), clearScrollRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.clearScroll(elasticsearchClearScrollRequest, RequestOptions.DEFAULT);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }
}

