/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.ClosePointInTimeRequestExecutor;
import java.io.IOException;
import org.elasticsearch.action.search.ClosePointInTimeRequest;
import org.elasticsearch.action.search.ClosePointInTimeResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ClosePointInTimeRequestExecutor.class})
public class ClosePointInTimeRequestExecutorImpl
implements ClosePointInTimeRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public com.liferay.portal.search.engine.adapter.search.ClosePointInTimeResponse execute(com.liferay.portal.search.engine.adapter.search.ClosePointInTimeRequest closePointInTimeRequest) {
        ClosePointInTimeRequest elasticsearchClosePointInTimeRequest = this.createClosePointInTimeRequest(closePointInTimeRequest);
        ClosePointInTimeResponse closePointInTimeResponse = this.getClosePointInTimeResponse(elasticsearchClosePointInTimeRequest, closePointInTimeRequest);
        return new com.liferay.portal.search.engine.adapter.search.ClosePointInTimeResponse(closePointInTimeResponse.getNumFreed());
    }

    protected ClosePointInTimeRequest createClosePointInTimeRequest(com.liferay.portal.search.engine.adapter.search.ClosePointInTimeRequest closePointInTimeSearchRequest) {
        return new ClosePointInTimeRequest(closePointInTimeSearchRequest.getPointInTimeId());
    }

    protected ClosePointInTimeResponse getClosePointInTimeResponse(ClosePointInTimeRequest elasticsearchClosePointInTimeRequest, com.liferay.portal.search.engine.adapter.search.ClosePointInTimeRequest closePointInTimeRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(closePointInTimeRequest.getConnectionId(), closePointInTimeRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.closePointInTime(elasticsearchClosePointInTimeRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

