/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.OpenPointInTimeRequestExecutor;
import java.io.IOException;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenPointInTimeRequestExecutor.class})
public class OpenPointInTimeRequestExecutorImpl
implements OpenPointInTimeRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public com.liferay.portal.search.engine.adapter.search.OpenPointInTimeResponse execute(com.liferay.portal.search.engine.adapter.search.OpenPointInTimeRequest openPointInTimeRequest) {
        OpenPointInTimeRequest elasticsearchOpenPointInTimeRequest = this.createOpenPointInTimeRequest(openPointInTimeRequest);
        OpenPointInTimeResponse openPointInTimeResponse = this.getOpenPointInTimeResponse(elasticsearchOpenPointInTimeRequest, openPointInTimeRequest);
        return new com.liferay.portal.search.engine.adapter.search.OpenPointInTimeResponse(openPointInTimeResponse.getPointInTimeId());
    }

    protected OpenPointInTimeRequest createOpenPointInTimeRequest(com.liferay.portal.search.engine.adapter.search.OpenPointInTimeRequest openPointInTimeRequest) {
        OpenPointInTimeRequest elasticsearchOpenPointInTimeRequest = new OpenPointInTimeRequest(new String[0]);
        if (openPointInTimeRequest.getIndices() != null) {
            elasticsearchOpenPointInTimeRequest.indices(openPointInTimeRequest.getIndices());
        }
        elasticsearchOpenPointInTimeRequest.keepAlive(TimeValue.timeValueMinutes((long)openPointInTimeRequest.getKeepAliveMinutes()));
        return elasticsearchOpenPointInTimeRequest;
    }

    protected OpenPointInTimeResponse getOpenPointInTimeResponse(OpenPointInTimeRequest elasticsearchOpenPointInTimeRequest, com.liferay.portal.search.engine.adapter.search.OpenPointInTimeRequest openPointInTimeRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(openPointInTimeRequest.getConnectionId(), openPointInTimeRequest.isPreferLocalCluster());
        try {
            return restHighLevelClient.openPointInTime(elasticsearchOpenPointInTimeRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

