/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.AggregationResultTranslator;
import com.liferay.portal.search.aggregation.AggregationResults;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationResultTranslator;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.AggregationResultTranslatorFactory;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.ElasticsearchAggregationResultTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.ElasticsearchAggregationResultsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.PipelineAggregationResultTranslatorFactory;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.pipeline.ElasticsearchPipelineAggregationResultTranslator;
import com.liferay.portal.search.elasticsearch7.internal.hits.SearchHitsTranslator;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.CommonSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch7.internal.search.response.SearchResponseTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.highlight.HighlightFieldBuilderFactory;
import com.liferay.portal.search.hits.SearchHitBuilderFactory;
import com.liferay.portal.search.hits.SearchHitsBuilderFactory;
import com.liferay.portal.search.searcher.SearchTimeValue;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSearchResponseAssembler.class})
public class SearchSearchResponseAssemblerImpl
implements AggregationResultTranslatorFactory,
PipelineAggregationResultTranslatorFactory,
SearchSearchResponseAssembler {
    @Reference
    private AggregationResults _aggregationResults;
    @Reference
    private CommonSearchResponseAssembler _commonSearchResponseAssembler;
    @Reference
    private DocumentBuilderFactory _documentBuilderFactory;
    @Reference
    private GeoBuilders _geoBuilders;
    @Reference
    private HighlightFieldBuilderFactory _highlightFieldBuilderFactory;
    @Reference
    private SearchHitBuilderFactory _searchHitBuilderFactory;
    @Reference
    private SearchHitsBuilderFactory _searchHitsBuilderFactory;
    @Reference
    private SearchResponseTranslator _searchResponseTranslator;

    @Override
    public void assemble(SearchSourceBuilder searchRequestBuilder, SearchResponse searchResponse, SearchSearchRequest searchSearchRequest, SearchSearchResponse searchSearchResponse) {
        this._commonSearchResponseAssembler.assemble(searchRequestBuilder, searchResponse, (BaseSearchRequest)searchSearchRequest, (BaseSearchResponse)searchSearchResponse);
        this._addAggregations(searchResponse, searchSearchResponse, searchSearchRequest);
        this.setCount(searchResponse, searchSearchResponse);
        this._setScrollId(searchResponse, searchSearchResponse);
        this._setSearchHits(searchResponse, searchSearchResponse, searchSearchRequest);
        this._setSearchTimeValue(searchResponse, searchSearchResponse);
        this._searchResponseTranslator.populate(searchSearchResponse, searchResponse, searchSearchRequest);
    }

    @Override
    public AggregationResultTranslator createAggregationResultTranslator(Aggregation elasticsearchAggregation) {
        return new ElasticsearchAggregationResultTranslator(elasticsearchAggregation, this._aggregationResults, new SearchHitsTranslator(this._searchHitBuilderFactory, this._searchHitsBuilderFactory, this._documentBuilderFactory, this._highlightFieldBuilderFactory, this._geoBuilders), this._geoBuilders);
    }

    @Override
    public PipelineAggregationResultTranslator createPipelineAggregationResultTranslator(Aggregation elasticsearchAggregation) {
        return new ElasticsearchPipelineAggregationResultTranslator(elasticsearchAggregation, this._aggregationResults);
    }

    protected void setCount(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse) {
        SearchHits searchHits = searchResponse.getHits();
        TotalHits totalHits = searchHits.getTotalHits();
        searchSearchResponse.setCount(totalHits.value);
    }

    private void _addAggregations(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse, SearchSearchRequest searchSearchRequest) {
        Aggregations elasticsearchAggregations = searchResponse.getAggregations();
        if (elasticsearchAggregations == null) {
            return;
        }
        Map aggregationsMap = searchSearchRequest.getAggregationsMap();
        Map pipelineAggregationsMap = searchSearchRequest.getPipelineAggregationsMap();
        ElasticsearchAggregationResultsTranslator elasticsearchAggregationResultsTranslator = new ElasticsearchAggregationResultsTranslator(this, this, aggregationsMap::get, pipelineAggregationsMap::get);
        List<AggregationResult> aggregationResults = elasticsearchAggregationResultsTranslator.translate(elasticsearchAggregations);
        for (AggregationResult aggregationResult : aggregationResults) {
            searchSearchResponse.addAggregationResult(aggregationResult);
        }
    }

    private void _setScrollId(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse) {
        if (Validator.isNotNull((String)searchResponse.getScrollId())) {
            searchSearchResponse.setScrollId(searchResponse.getScrollId());
        }
    }

    private void _setSearchHits(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse, SearchSearchRequest searchSearchRequest) {
        SearchHitsTranslator searchHitsTranslator = new SearchHitsTranslator(this._searchHitBuilderFactory, this._searchHitsBuilderFactory, this._documentBuilderFactory, this._highlightFieldBuilderFactory, this._geoBuilders);
        SearchHits searchHits = searchResponse.getHits();
        searchSearchResponse.setSearchHits(searchHitsTranslator.translate(searchHits, searchSearchRequest.getAlternateUidFieldName()));
    }

    private void _setSearchTimeValue(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse) {
        TimeValue took = searchResponse.getTook();
        SearchTimeValue.Builder builder = SearchTimeValue.Builder.newBuilder();
        builder.duration(took.duration()).timeUnit(took.timeUnit());
        searchSearchResponse.setSearchTimeValue(builder.build());
    }
}

