/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch7.internal.search.engine.adapter.snapshot.RestoreSnapshotRequestExecutor;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SnapshotClient;
import org.elasticsearch.snapshots.RestoreInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RestoreSnapshotRequestExecutor.class})
public class RestoreSnapshotRequestExecutorImpl
implements RestoreSnapshotRequestExecutor {
    @Reference
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotResponse execute(com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotRequest restoreSnapshotRequest) {
        RestoreSnapshotRequest elasticsearchRestoreSnapshotRequest = this.createRestoreSnapshotRequest(restoreSnapshotRequest);
        RestoreSnapshotResponse elasticsearchRestoreSnapshotResponse = this._getRestoreSnapshotResponse(elasticsearchRestoreSnapshotRequest, restoreSnapshotRequest);
        RestoreInfo restoreInfo = elasticsearchRestoreSnapshotResponse.getRestoreInfo();
        List indexNames = restoreInfo.indices();
        return new com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotResponse(restoreInfo.name(), indexNames.toArray(new String[0]), restoreInfo.totalShards(), restoreInfo.failedShards());
    }

    protected RestoreSnapshotRequest createRestoreSnapshotRequest(com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotRequest restoreSnapshotRequest) {
        RestoreSnapshotRequest elasticsearchRestoreSnapshotRequest = new RestoreSnapshotRequest();
        elasticsearchRestoreSnapshotRequest.includeAliases(restoreSnapshotRequest.isIncludeAliases());
        elasticsearchRestoreSnapshotRequest.indices(restoreSnapshotRequest.getIndexNames());
        elasticsearchRestoreSnapshotRequest.partial(restoreSnapshotRequest.isPartialRestore());
        if (Validator.isNotNull((String)restoreSnapshotRequest.getRenameReplacement())) {
            elasticsearchRestoreSnapshotRequest.renameReplacement(restoreSnapshotRequest.getRenameReplacement());
        }
        if (Validator.isNotNull((String)restoreSnapshotRequest.getRenamePattern())) {
            elasticsearchRestoreSnapshotRequest.renamePattern(restoreSnapshotRequest.getRenamePattern());
        }
        elasticsearchRestoreSnapshotRequest.repository(restoreSnapshotRequest.getRepositoryName());
        elasticsearchRestoreSnapshotRequest.includeGlobalState(restoreSnapshotRequest.isRestoreGlobalState());
        elasticsearchRestoreSnapshotRequest.snapshot(restoreSnapshotRequest.getSnapshotName());
        elasticsearchRestoreSnapshotRequest.waitForCompletion(restoreSnapshotRequest.isWaitForCompletion());
        return elasticsearchRestoreSnapshotRequest;
    }

    private RestoreSnapshotResponse _getRestoreSnapshotResponse(RestoreSnapshotRequest elasticsearchRestoreSnapshotRequest, com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotRequest restoreSnapshotRequest) {
        RestHighLevelClient restHighLevelClient = this._elasticsearchClientResolver.getRestHighLevelClient(restoreSnapshotRequest.getConnectionId(), restoreSnapshotRequest.isPreferLocalCluster());
        SnapshotClient snapshotClient = restHighLevelClient.snapshot();
        try {
            return snapshotClient.restore(elasticsearchRestoreSnapshotRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

