/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.search.response;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HitsImpl
implements Hits {
    private static final Document[] _EMPTY_DOCUMENTS = new Document[0];
    private String _collatedSpellCheckResult;
    private Document[] _docs = _EMPTY_DOCUMENTS;
    private final Map<String, Hits> _groupedHits = new LinkedHashMap<String, Hits>();
    private int _length;
    private Query _query;
    private String[] _querySuggestions;
    private String[] _queryTerms;
    private float[] _scores = new float[0];
    private float _searchTime;
    private String[] _snippets = new String[0];
    private Map<String, List<String>> _spellCheckResults;
    private long _start;
    private final Map<String, StatsResults> _statsResults = new HashMap<String, StatsResults>();

    public void addGroupedHits(String groupValue, Hits hits) {
        this._groupedHits.put(groupValue, hits);
    }

    public void addStatsResults(StatsResults statsResults) {
        this._statsResults.put(statsResults.getField(), statsResults);
    }

    public void copy(Hits hits) {
        this.setDocs(hits.getDocs());
        this.setLength(hits.getLength());
        this.setQuery(hits.getQuery());
        this.setQuerySuggestions(hits.getQuerySuggestions());
        this.setQueryTerms(hits.getQueryTerms());
        this.setScores(hits.getScores());
        this.setSearchTime(hits.getSearchTime());
        this.setSnippets(hits.getSnippets());
        this.setSpellCheckResults(hits.getSpellCheckResults());
        this.setStart(hits.getStart());
    }

    public Document doc(int n) {
        return this._docs[n];
    }

    @JSON
    public String getCollatedSpellCheckResult() {
        return this._collatedSpellCheckResult;
    }

    @JSON
    public Document[] getDocs() {
        return this._docs;
    }

    public Map<String, Hits> getGroupedHits() {
        return Collections.unmodifiableMap(this._groupedHits);
    }

    public int getLength() {
        return this._length;
    }

    @JSON(include=false)
    public Query getQuery() {
        return this._query;
    }

    @JSON
    public String[] getQuerySuggestions() {
        if (ArrayUtil.isEmpty((Object[])this._querySuggestions)) {
            return StringPool.EMPTY_ARRAY;
        }
        return this._querySuggestions;
    }

    @JSON
    public String[] getQueryTerms() {
        return this._queryTerms;
    }

    @JSON
    public float[] getScores() {
        return this._scores;
    }

    public float getSearchTime() {
        return this._searchTime;
    }

    @JSON
    public String[] getSnippets() {
        return this._snippets;
    }

    public Map<String, List<String>> getSpellCheckResults() {
        return this._spellCheckResults;
    }

    public long getStart() {
        return this._start;
    }

    public Map<String, StatsResults> getStatsResults() {
        return Collections.unmodifiableMap(this._statsResults);
    }

    public boolean hasGroupedHits() {
        return !this._groupedHits.isEmpty();
    }

    public float score(int n) {
        return this._scores[n];
    }

    public void setCollatedSpellCheckResult(String collatedSpellCheckResult) {
        this._collatedSpellCheckResult = collatedSpellCheckResult;
    }

    public void setDocs(Document[] docs) {
        this._docs = docs;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public void setQuery(Query query) {
        this._query = query;
    }

    public void setQuerySuggestions(String[] querySuggestions) {
        this._querySuggestions = querySuggestions;
    }

    public void setQueryTerms(String[] queryTerms) {
        this._queryTerms = queryTerms;
    }

    public void setScores(float[] scores) {
        this._scores = scores;
    }

    public void setSearchTime(float time) {
        this._searchTime = time;
    }

    public void setSnippets(String[] snippets) {
        this._snippets = snippets;
    }

    public void setSpellCheckResults(Map<String, List<String>> spellCheckResults) {
        this._spellCheckResults = spellCheckResults;
    }

    public void setStart(long start) {
        this._start = start;
    }

    public String snippet(int n) {
        return this._snippets[n];
    }

    public List<Document> toList() {
        return Arrays.asList(this._docs);
    }

    public String toString() {
        if (ArrayUtil.isEmpty((Object[])this._docs)) {
            return StringBundler.concat((Object[])new Object[]{"{docs={}, length=", this._length, ", query=", this._query, "]"});
        }
        StringBundler sb = new StringBundler(2 * this._docs.length + 4);
        sb.append("[");
        for (Document document : this._docs) {
            sb.append((Object)document);
            sb.append(", ");
        }
        sb.setStringAt("}, length=", sb.index() - 1);
        sb.append(this._length);
        sb.append(", query=");
        sb.append((Object)this._query);
        sb.append("]");
        return sb.toString();
    }
}

