/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.settings;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.XContentType;

public class SettingsBuilder {
    private final Settings.Builder _builder;

    public SettingsBuilder(Settings.Builder builder) {
        this._builder = builder;
    }

    public Settings build() {
        return this._builder.build();
    }

    public String get(String key) {
        return this._builder.get(key);
    }

    public Settings.Builder getBuilder() {
        return this._builder;
    }

    public void loadFromSource(String source) {
        if (StringUtils.isBlank((String)source)) {
            return;
        }
        if ((source = source.trim()).charAt(0) == '{') {
            this._builder.loadFromSource(source, XContentType.JSON);
        } else {
            this._builder.loadFromSource(source, XContentType.YAML);
        }
    }

    public void put(String key, boolean value) {
        this._builder.put(key, value);
    }

    public void put(String key, String value) {
        if (!StringUtils.isBlank((String)value)) {
            this._builder.put(key, value);
        }
    }

    public void putList(String setting, String ... values) {
        this._builder.putList(setting, values);
    }
}

