/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class ClassModificationUtil {
    public static byte[] getModifiedClassBytes(String className, final String methodName, final Consumer<MethodVisitor> methodVisitorConsumer, ClassLoader classLoader) throws ClassNotFoundException, IOException {
        Class<?> clazz = classLoader.loadClass(className);
        try (InputStream inputStream = clazz.getResourceAsStream(clazz.getSimpleName() + ".class");){
            ClassReader classReader = new ClassReader(inputStream);
            ClassWriter classWriter = new ClassWriter(classReader, 1);
            classReader.accept(new ClassVisitor(327680, (ClassVisitor)classWriter){

                public MethodVisitor visitMethod(int access, String name, String description, String signature, String[] exceptions) {
                    final MethodVisitor methodVisitor = super.visitMethod(access, name, description, signature, exceptions);
                    if (!name.equals(methodName)) {
                        return methodVisitor;
                    }
                    return new MethodVisitor(327680){

                        public void visitCode() {
                            methodVisitorConsumer.accept(methodVisitor);
                        }

                        public void visitMaxs(int maxStack, int maxLocals) {
                            methodVisitor.visitMaxs(0, 0);
                        }
                    };
                }
            }, 0);
            byte[] byArray = classWriter.toByteArray();
            return byArray;
        }
    }
}

