/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Distributable;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Distribution;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.PathUtil;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.UncompressUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class ElasticsearchInstaller {
    private static final Path _temporaryDirectoryPath = ElasticsearchInstaller._getTemporaryDirectoryPath();
    private Path _distributablesDirectoryPath;
    private Distribution _distribution;
    private Path _installationDirectoryPath;

    public static Builder builder() {
        return new Builder();
    }

    public ElasticsearchInstaller() {
    }

    public ElasticsearchInstaller(ElasticsearchInstaller elasticsearchInstaller) {
        this._distributablesDirectoryPath = elasticsearchInstaller._distributablesDirectoryPath;
        this._distribution = elasticsearchInstaller._distribution;
        this._installationDirectoryPath = elasticsearchInstaller._installationDirectoryPath;
    }

    public void install() {
        if (this._isAlreadyInstalled()) {
            return;
        }
        this._createDestinationDirectory();
        try {
            this._createTemporaryDownloadDirectory();
            try {
                this._downloadAndInstallElasticsearch();
                this._downloadAndInstallPlugins();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                this._deleteTemporaryDownloadDirectory();
            }
        }
        catch (RuntimeException runtimeException) {
            this._deleteDestinationDirectory();
            throw runtimeException;
        }
    }

    protected static String getChecksum(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            String string = DigestUtils.sha512Hex((InputStream)inputStream);
            return string;
        }
    }

    protected void createDirectories(Path directoryPath) {
        try {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static Path _getTemporaryDirectoryPath() {
        Path path = Paths.get(SystemProperties.get((String)"java.io.tmpdir"), new String[0]);
        return path.resolve(ElasticsearchInstaller.class.getSimpleName());
    }

    private void _createDestinationDirectory() {
        this.createDirectories(this._installationDirectoryPath);
    }

    private void _createTemporaryDownloadDirectory() {
        this.createDirectories(_temporaryDirectoryPath);
    }

    private void _deleteDestinationDirectory() {
        PathUtil.deleteDir(this._installationDirectoryPath);
    }

    private void _deleteTemporaryDownloadDirectory() {
        PathUtil.deleteDir(_temporaryDirectoryPath);
    }

    private void _downloadAndInstallElasticsearch() throws IOException {
        String rootArchiveName = UncompressUtil.unarchive(this._getFilePath(this._distribution.getElasticsearchDistributable()), _temporaryDirectoryPath);
        PathUtil.copyDirectory(_temporaryDirectoryPath.resolve(rootArchiveName), this._installationDirectoryPath, new Path[0]);
    }

    private void _downloadAndInstallPlugin(Distributable distributable) throws IOException {
        Path filePath = this._getFilePath(distributable);
        String pluginName = StringUtils.substringBeforeLast((String)String.valueOf(filePath.getFileName()), (String)"-");
        Path extractedDirectoryPath = _temporaryDirectoryPath.resolve(pluginName);
        UncompressUtil.unzip(filePath, extractedDirectoryPath);
        Path pluginsDirectoryPath = this._installationDirectoryPath.resolve("plugins");
        this.createDirectories(pluginsDirectoryPath);
        Path pluginDestinationDirectoryPath = pluginsDirectoryPath.resolve(pluginName);
        PathUtil.copyDirectory(extractedDirectoryPath, pluginDestinationDirectoryPath, new Path[0]);
    }

    private void _downloadAndInstallPlugins() throws IOException {
        for (Distributable distributable : this._distribution.getPluginDistributables()) {
            this._downloadAndInstallPlugin(distributable);
        }
    }

    private Path _getFilePath(Distributable distributable) throws IOException {
        Path filePath = this._locateOrDownload(distributable);
        this._guardChecksum(filePath, distributable.getChecksum());
        return filePath;
    }

    private void _guardChecksum(Path filePath, String checksum) throws IOException {
        if (!checksum.equals(ElasticsearchInstaller.getChecksum(filePath))) {
            throw new RuntimeException("Checksum mismatch");
        }
    }

    private boolean _isAlreadyInstalled() {
        return Files.exists(this._installationDirectoryPath, new LinkOption[0]);
    }

    private Path _locateOrDownload(Distributable distributable) throws IOException {
        String downloadURLString = distributable.getDownloadURLString();
        String fileName = StringUtils.substringAfterLast((String)downloadURLString, (String)"/");
        Path distributableFilePath = this._distributablesDirectoryPath.resolve(fileName);
        if (Files.exists(distributableFilePath, new LinkOption[0])) {
            return distributableFilePath;
        }
        Path downloadedFilePath = _temporaryDirectoryPath.resolve(fileName);
        PathUtil.download(new URL(downloadURLString), downloadedFilePath);
        return downloadedFilePath;
    }

    public static class Builder {
        private final ElasticsearchInstaller _elasticsearchInstaller = new ElasticsearchInstaller();

        public ElasticsearchInstaller build() {
            return new ElasticsearchInstaller(this._elasticsearchInstaller);
        }

        public Builder distributablesDirectoryPath(Path distributablesDirectoryPath) {
            this._elasticsearchInstaller._distributablesDirectoryPath = distributablesDirectoryPath;
            return this;
        }

        public Builder distribution(Distribution distribution) {
            this._elasticsearchInstaller._distribution = distribution;
            return this;
        }

        public Builder installationDirectoryPath(Path installationDirectoryPath) {
            this._elasticsearchInstaller._installationDirectoryPath = installationDirectoryPath;
            return this;
        }
    }
}

