/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class PathUtil {
    private static final Log _log = LogFactoryUtil.getLog(PathUtil.class);

    public static void copyDirectory(final Path fromPath, final Path toPath, Path ... excludedPaths) throws IOException {
        final List<Path> excludedPathList = Arrays.asList(excludedPaths);
        if (Files.exists(toPath, new LinkOption[0])) {
            PathUtil.deleteDir(toPath);
        }
        final HashMap fileTimes = new HashMap();
        try {
            Files.walkFileTree(fromPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException ioException) throws IOException {
                    FileTime fileTime = (FileTime)fileTimes.remove(dir);
                    if (fileTime == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.setLastModifiedTime(toPath.resolve(fromPath.relativize(dir)), fileTime);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (excludedPathList.contains(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.copy(dir, toPath.resolve(fromPath.relativize(dir)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    fileTimes.put(dir, Files.getLastModifiedTime(dir, new LinkOption[0]));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (excludedPathList.contains(file.getParent())) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path toFile = toPath.resolve(fromPath.relativize(file));
                    Files.copy(file, toFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            PathUtil.deleteDir(toPath);
            throw ioException;
        }
    }

    public static void deleteDir(Path dirPath) {
        block3: {
            if (dirPath == null) {
                return;
            }
            try {
                Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException ioException) throws IOException {
                        if (ioException != null) {
                            throw ioException;
                        }
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path path, IOException ioException) throws IOException {
                        if (ioException instanceof NoSuchFileException) {
                            return FileVisitResult.CONTINUE;
                        }
                        throw ioException;
                    }
                });
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to delete " + dirPath), (Throwable)ioException);
            }
        }
    }

    public static void download(URL url, Path path) throws IOException {
        try (InputStream inputStream = url.openStream();){
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

