/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.petra.concurrent.FutureListener;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ClassPathUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.process.ProcessLog;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ClassModificationUtil;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Distribution;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ElasticsearchDistribution;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ElasticsearchInstaller;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ElasticsearchInstancePaths;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ElasticsearchInstanceSettingsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.HttpPortRange;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.PathUtil;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.SidecarMainProcessCallable;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.SidecarManager;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.StartSidecarProcessCallable;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.StopSidecarProcessCallable;
import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.settings.Settings;

public class Sidecar {
    private static final Log _log = LogFactoryUtil.getLog(Sidecar.class);
    private String _address;
    private final ElasticsearchConfigurationWrapper _elasticsearchConfigurationWrapper;
    private final ElasticsearchInstancePaths _elasticsearchInstancePaths;
    private ProcessChannel<Serializable> _processChannel;
    private final ProcessExecutor _processExecutor;
    private FutureListener<Serializable> _restartFutureListener;
    private final Path _sidecarHomePath;
    private SidecarManager _sidecarManager;
    private Path _sidecarTempDirPath;

    public Sidecar(ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper, ElasticsearchInstancePaths elasticsearchInstancePaths, ProcessExecutor processExecutor, SidecarManager sidecarManager) {
        this._elasticsearchConfigurationWrapper = elasticsearchConfigurationWrapper;
        this._elasticsearchInstancePaths = elasticsearchInstancePaths;
        this._processExecutor = processExecutor;
        this._sidecarManager = sidecarManager;
        this._sidecarHomePath = elasticsearchInstancePaths.getHomePath();
    }

    public String getNetworkHostAddress() {
        return this._address;
    }

    public void start() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Sidecar Elasticsearch starting");
        }
        this._installElasticsearchIfNeeded();
        ProcessChannel<Serializable> processChannel = this._executeSidecarMainProcess();
        RestartFutureListener futureListener = new RestartFutureListener(this._sidecarManager);
        this._addFutureListener(processChannel, futureListener);
        String address = this._startElasticsearch(processChannel);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Sidecar Elasticsearch ", this._getNodeVersion(), " ", this._getNodeName(), " started at ", address}));
        }
        this._address = address;
        this._processChannel = processChannel;
        this._restartFutureListener = futureListener;
    }

    public void stop() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Stopping sidecar Elasticsearch");
        }
        if (this._processChannel != null) {
            block5: {
                NoticeableFuture noticeableFuture = this._processChannel.getProcessNoticeableFuture();
                noticeableFuture.removeFutureListener(this._restartFutureListener);
                this._processChannel.write((ProcessCallable)new StopSidecarProcessCallable());
                try {
                    noticeableFuture.get(this._elasticsearchConfigurationWrapper.sidecarShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    if (noticeableFuture.isDone()) break block5;
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Forcibly shutdown sidecar Elasticsearch ", "process because it did not shut down in ", this._elasticsearchConfigurationWrapper.sidecarShutdownTimeout(), " ms"}), (Throwable)exception);
                    }
                    noticeableFuture.cancel(true);
                }
            }
            this._processChannel = null;
        }
        PathUtil.deleteDir(this._sidecarTempDirPath);
    }

    private void _addFutureListener(ProcessChannel<Serializable> processChannel, FutureListener<Serializable> futureListener) {
        NoticeableFuture noticeableFuture = processChannel.getProcessNoticeableFuture();
        noticeableFuture.addFutureListener(futureListener);
    }

    private void _consumeProcessLog(ProcessLog processLog) {
        if (ProcessLog.Level.DEBUG == processLog.getLevel()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)processLog.getMessage(), processLog.getThrowable());
            }
        } else if (ProcessLog.Level.INFO == processLog.getLevel()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)processLog.getMessage(), processLog.getThrowable());
            }
        } else if (ProcessLog.Level.WARN == processLog.getLevel()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)processLog.getMessage(), processLog.getThrowable());
            }
        } else {
            _log.error((Object)processLog.getMessage(), processLog.getThrowable());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _createClasspath(Path dirPath, DirectoryStream.Filter<Path> filter) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath, filter);){
            StringBundler sb = new StringBundler();
            directoryStream.forEach(path -> {
                sb.append(path);
                sb.append(File.pathSeparator);
            });
            if (sb.index() > 0) {
                sb.setIndex(sb.index() - 1);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to iterate " + dirPath, ioException);
        }
    }

    private ProcessConfig _createProcessConfig(String sidecarLibClassPath) {
        ProcessConfig.Builder builder = new ProcessConfig.Builder();
        URL bundleURL = this._getBundleURL();
        return builder.setArguments(this._getJVMArguments(bundleURL)).setBootstrapClassPath(this._getBootstrapClassPath()).setEnvironment(this._getEnvironment()).setJavaExecutable(System.getProperty("java.home") + "/bin/java").setProcessLogConsumer(this::_consumeProcessLog).setReactClassLoader(Sidecar.class.getClassLoader()).setRuntimeClassPath(StringBundler.concat((String[])new String[]{sidecarLibClassPath, File.pathSeparator, bundleURL.getPath(), File.pathSeparator, this._getBootstrapClassPath()})).build();
    }

    private ProcessChannel<Serializable> _executeSidecarMainProcess() {
        if (!Files.isDirectory(this._sidecarHomePath, new LinkOption[0])) {
            throw new IllegalArgumentException("Sidecar Elasticsearch home does not exist: " + this._sidecarHomePath);
        }
        String sidecarLibClassPath = this._createClasspath(this._sidecarHomePath.resolve("lib"), path -> true);
        try {
            return this._processExecutor.execute(this._createProcessConfig(sidecarLibClassPath), (ProcessCallable)new SidecarMainProcessCallable(this._elasticsearchConfigurationWrapper.sidecarHeartbeatInterval(), this._getModifiedClasses(sidecarLibClassPath)));
        }
        catch (ProcessException processException) {
            throw new RuntimeException("Unable to start sidecar Elasticsearch process", processException);
        }
    }

    private boolean _fileNameContains(Path path, String s) {
        String name = String.valueOf(path.getFileName());
        return name.contains(s);
    }

    private String _getBootstrapClassPath() {
        return this._createClasspath(Paths.get(PropsValues.LIFERAY_SHIELDED_CONTAINER_LIB_PORTAL_DIR, new String[0]), path -> this._fileNameContains((Path)path, "petra"));
    }

    private URL _getBundleURL() {
        ProtectionDomain protectionDomain = Sidecar.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        return codeSource.getLocation();
    }

    private String _getClusterName() {
        return this._elasticsearchConfigurationWrapper.clusterName();
    }

    private Distribution _getElasticsearchDistribution() {
        String versionNumber = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/sidecar/sidecar.version");
        if (versionNumber.equals("7.17.21")) {
            return new ElasticsearchDistribution();
        }
        throw new IllegalArgumentException("Unsupported Elasticsearch version: " + versionNumber);
    }

    private HashMap<String, String> _getEnvironment() {
        return HashMapBuilder.putAll(System.getenv()).put((Object)"HOSTNAME", (Object)"localhost").put((Object)"LIBFFI_TMPDIR", (Object)this._sidecarHomePath.toString()).build();
    }

    private List<String> _getJVMArguments(URL bundleURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (String jvmOption : this._elasticsearchConfigurationWrapper.sidecarJVMOptions()) {
            if (jvmOption.contains("|")) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)(jvmOption + " is not a valid format for the JVM options and will be ignored"));
                continue;
            }
            arguments.add(jvmOption);
        }
        if (this._elasticsearchConfigurationWrapper.sidecarDebug()) {
            arguments.add(this._elasticsearchConfigurationWrapper.sidecarDebugSettings());
        }
        try {
            this._sidecarTempDirPath = Files.createTempDirectory("sidecar", new FileAttribute[0]);
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Unable to create temp folder", ioException);
        }
        Path configFolder = this._sidecarTempDirPath.resolve("config");
        try {
            Files.createDirectories(configFolder, new FileAttribute[0]);
            Files.write(configFolder.resolve("log4j2.properties"), Arrays.asList("logger.bootstrapchecks.name=org.elasticsearch.bootstrap.BootstrapChecks", "logger.bootstrapchecks.level=error", "logger.deprecation.name=org.elasticsearch.deprecation", "logger.deprecation.level=error", this._getLogProperties(), ResourceUtil.getResourceAsString(Sidecar.class, "/log4j2-sidecar.properties")), new OpenOption[0]);
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to copy log4j2.properties to " + configFolder), (Throwable)ioException);
        }
        arguments.add("-Des.path.conf=" + configFolder);
        arguments.add("-Des.networkaddress.cache.ttl=60");
        arguments.add("-Des.networkaddress.cache.negative.ttl=10");
        arguments.add("-Dlog4j.shutdownHookEnabled=false");
        arguments.add("-Dlog4j2.disable.jmx=true");
        arguments.add("-Dio.netty.allocator.type=unpooled");
        arguments.add("-Dio.netty.allocator.numDirectArenas=0");
        arguments.add("-Dio.netty.noUnsafe=true");
        arguments.add("-Dio.netty.noKeySetOptimization=true");
        arguments.add("-Dio.netty.recycler.maxCapacityPerThread=0");
        arguments.add("-Dfile.encoding=UTF-8");
        arguments.add("-Djava.io.tmpdir=" + this._sidecarTempDirPath);
        if (JavaDetector.isJDK21()) {
            arguments.add("-Djava.security.manager=allow");
        }
        arguments.add("-Djava.security.policy=" + String.valueOf(this._getSecurityPolicyURL(bundleURL)));
        arguments.add("-Djna.nosys=true");
        if (JavaDetector.isJDK21() && OSDetector.isLinux()) {
            arguments.add("-XX:-UseContainerSupport");
        }
        return arguments;
    }

    private String _getLogProperties() {
        return "";
    }

    private Map<String, byte[]> _getModifiedClasses(String sidecarLibClassPath) {
        HashMap<String, byte[]> modifiedClasses = new HashMap<String, byte[]>();
        try {
            URLClassLoader classLoader = new URLClassLoader(ClassPathUtil.getClassPathURLs((String)sidecarLibClassPath), null);
            modifiedClasses.put("org.elasticsearch.bootstrap.Natives", ClassModificationUtil.getModifiedClassBytes("org.elasticsearch.bootstrap.Natives", "definitelyRunningAsRoot", methodVisitor -> {
                methodVisitor.visitCode();
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(172);
            }, classLoader));
            modifiedClasses.put("org.elasticsearch.common.settings.KeyStoreWrapper", ClassModificationUtil.getModifiedClassBytes("org.elasticsearch.common.settings.KeyStoreWrapper", "save", methodVisitor -> {
                methodVisitor.visitCode();
                methodVisitor.visitInsn(177);
            }, classLoader));
            modifiedClasses.put("org.elasticsearch.bootstrap.Security", ClassModificationUtil.getModifiedClassBytes("org.elasticsearch.bootstrap.Security", "configure", methodVisitor -> {
                methodVisitor.visitCode();
                methodVisitor.visitInsn(177);
            }, classLoader));
            modifiedClasses.put("org.elasticsearch.bootstrap.Spawner", ClassModificationUtil.getModifiedClassBytes("org.elasticsearch.bootstrap.Spawner", "spawnNativeControllers", methodVisitor -> {
                methodVisitor.visitCode();
                methodVisitor.visitInsn(177);
            }, classLoader));
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to modify classes", (Throwable)exception);
        }
        return modifiedClasses;
    }

    private String _getNodeName() {
        String nodeName = this._elasticsearchConfigurationWrapper.nodeName();
        if (!Validator.isBlank((String)nodeName)) {
            return nodeName;
        }
        return "liferay_sidecar";
    }

    private String _getNodeVersion() {
        return ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/sidecar/sidecar.version");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL _getSecurityPolicyURL(URL bundleURL) {
        try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{bundleURL});){
            URL uRL = urlClassLoader.findResource("/META-INF/sidecar/sidecar.policy");
            return uRL;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private Settings _getSettings() {
        return ElasticsearchInstanceSettingsBuilder.builder().clusterName(this._getClusterName()).discoveryTypeSingleNode(true).elasticsearchConfigurationWrapper(this._elasticsearchConfigurationWrapper).elasticsearchInstancePaths(this._elasticsearchInstancePaths).httpPortRange(new HttpPortRange(this._elasticsearchConfigurationWrapper)).nodeName(this._getNodeName()).build();
    }

    private String[] _getSidecarArguments() {
        Settings settings = this._getSettings();
        StringBundler sb = new StringBundler(2 * settings.size() + 1);
        sb.append("Sidecar Elasticsearch properties : {");
        ArrayList<String> arguments = new ArrayList<String>();
        for (String key : settings.keySet()) {
            arguments.add("-E");
            List list = settings.getAsList(key);
            if (!ListUtil.isNotEmpty((List)list)) continue;
            String keyValue = StringBundler.concat((String[])new String[]{key, "=", StringUtil.merge((Collection)list)});
            arguments.add(keyValue);
            sb.append(keyValue);
            sb.append(",");
        }
        sb.setStringAt("}", sb.index() - 1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)sb.toString());
        }
        return arguments.toArray(new String[0]);
    }

    private void _installElasticsearchIfNeeded() {
        ElasticsearchInstaller.builder().distributablesDirectoryPath(this._elasticsearchInstancePaths.getWorkPath()).distribution(this._getElasticsearchDistribution()).installationDirectoryPath(this._sidecarHomePath).build().install();
    }

    private String _startElasticsearch(ProcessChannel<Serializable> processChannel) {
        NoticeableFuture noticeableFuture = processChannel.write((ProcessCallable)new StartSidecarProcessCallable(this._getSidecarArguments()));
        try {
            return this._waitForPublishedAddress((NoticeableFuture<String>)noticeableFuture);
        }
        catch (IOException ioException) {
            if (Objects.equals(ioException.getMessage(), "Stream closed")) {
                throw new RuntimeException(StringBundler.concat((String[])new String[]{"Sidecar JVM did not launch successfully. ", SidecarMainProcessCallable.class.getSimpleName(), " may have crashed, or its classpath may be missing ", "required libraries"}), ioException);
            }
            processChannel.write((ProcessCallable)new StopSidecarProcessCallable());
            throw new RuntimeException(ioException);
        }
        catch (Exception exception) {
            processChannel.write((ProcessCallable)new StopSidecarProcessCallable());
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    private String _waitForPublishedAddress(NoticeableFuture<String> noticeableFuture) throws Exception {
        try {
            return (String)noticeableFuture.get();
        }
        catch (ExecutionException executionException) {
            throw (Exception)executionException.getCause();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private static class RestartFutureListener
    implements FutureListener<Serializable> {
        private SidecarManager _sidecarManager;

        public RestartFutureListener(SidecarManager sidecarManager) {
            this._sidecarManager = sidecarManager;
        }

        public void complete(Future<Serializable> future) {
            block4: {
                try {
                    future.get();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)"Sidecar Elasticsearch process is aborted", (Throwable)exception);
                }
            }
            if (this._sidecarManager.isStartupSuccessful()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Restarting sidecar Elasticsearch process");
                }
                this._sidecarManager.applyConfigurations();
            }
        }
    }
}

