/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.local.LocalProcessLauncher;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ElasticsearchServerUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;

public class SidecarMainProcessCallable
implements ProcessCallable<Serializable> {
    private static final long serialVersionUID = 1L;
    private final long _heartbeatInterval;
    private final Map<String, byte[]> _modifiedClasses;

    public SidecarMainProcessCallable(long heartbeatInterval, Map<String, byte[]> modifiedClasses) {
        this._heartbeatInterval = heartbeatInterval;
        this._modifiedClasses = modifiedClasses;
    }

    public Serializable call() throws ProcessException {
        LocalProcessLauncher.ProcessContext.attach((String)"SidecarMainProcessCallable", (long)this._heartbeatInterval, (shutdownCode, shutdownThrowable) -> {
            ElasticsearchServerUtil.shutdown();
            return true;
        });
        this._loadModifiedClasses();
        ElasticsearchServerUtil.waitForShutdown();
        return null;
    }

    private void _loadModifiedClasses() throws ProcessException {
        ClassLoader classLoader = SidecarMainProcessCallable.class.getClassLoader();
        try {
            Method defineClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
            for (Map.Entry<String, byte[]> entry : this._modifiedClasses.entrySet()) {
                byte[] modifiedClassBytes = entry.getValue();
                defineClassMethod.invoke((Object)classLoader, entry.getKey(), modifiedClassBytes, 0, modifiedClassBytes.length);
            }
        }
        catch (Exception exception) {
            throw new ProcessException("Unable to load modified classes", (Throwable)exception);
        }
    }
}

