/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sidecar;

import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationObserver;
import com.liferay.portal.search.elasticsearch7.internal.configuration.ElasticsearchConfigurationWrapper;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionBuilder;
import com.liferay.portal.search.elasticsearch7.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ElasticsearchInstancePaths;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.ElasticsearchInstancePathsBuilder;
import com.liferay.portal.search.elasticsearch7.internal.sidecar.Sidecar;
import com.liferay.portal.search.elasticsearch7.internal.util.ResourceUtil;
import com.liferay.portal.util.PropsValues;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=true, service={})
public class SidecarManager
implements ElasticsearchConfigurationObserver {
    @Reference
    protected ElasticsearchConfigurationWrapper elasticsearchConfigurationWrapper;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected ProcessExecutor processExecutor;
    private static final Log _log = LogFactoryUtil.getLog(SidecarManager.class);
    private Sidecar _sidecar;
    private boolean _startupSuccessful;

    @Override
    public int compareTo(ElasticsearchConfigurationObserver elasticsearchConfigurationObserver) {
        return this.elasticsearchConfigurationWrapper.compare(this, elasticsearchConfigurationObserver);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void onElasticsearchConfigurationUpdate() {
        this.applyConfigurations();
    }

    @Activate
    protected void activate() {
        this.elasticsearchConfigurationWrapper.register(this);
        this.applyConfigurations();
    }

    protected void applyConfigurations() {
        if (this.elasticsearchConfigurationWrapper.isProductionModeEnabled()) {
            this.elasticsearchConnectionManager.removeElasticsearchConnection("__SIDECAR__");
        } else {
            this._startupSuccessful = false;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Liferay automatically starts a child process of ", "Elasticsearch named sidecar for convenient ", "development and demonstration purposes. Do NOT use ", "sidecar in production. Refer to the documentation ", "for details on the limitations of sidecar and ", "instructions on configuring a remote Elasticsearch ", "connection in the Control Panel."}));
            }
            if (this._sidecar != null) {
                this._sidecar.stop();
            }
            this._sidecar = new Sidecar(this.elasticsearchConfigurationWrapper, this._getElasticsearchInstancePaths(), this.processExecutor, this);
            ElasticsearchConnectionBuilder elasticsearchConnectionBuilder = new ElasticsearchConnectionBuilder();
            elasticsearchConnectionBuilder.active(true).connectionId("__SIDECAR__").maxConnections(this.elasticsearchConfigurationWrapper.maxConnections()).maxConnectionsPerRoute(this.elasticsearchConfigurationWrapper.maxConnectionsPerRoute()).postCloseRunnable(this._sidecar::stop).preConnectElasticsearchConnectionConsumer(elasticsearchConnection -> {
                this._sidecar.start();
                elasticsearchConnection.setNetworkHostAddresses(new String[]{this._sidecar.getNetworkHostAddress()});
            });
            this.elasticsearchConnectionManager.addElasticsearchConnection(elasticsearchConnectionBuilder.build());
            this._startupSuccessful = true;
        }
    }

    @Deactivate
    protected void deactivate() {
        this.elasticsearchConfigurationWrapper.unregister(this);
    }

    protected boolean isStartupSuccessful() {
        return this._startupSuccessful;
    }

    private ElasticsearchInstancePaths _getElasticsearchInstancePaths() {
        ElasticsearchInstancePathsBuilder elasticsearchInstancePathsBuilder = new ElasticsearchInstancePathsBuilder();
        Path workPath = Paths.get(PropsValues.LIFERAY_HOME, new String[0]);
        Path dataPath = workPath.resolve("data/elasticsearch7");
        return elasticsearchInstancePathsBuilder.dataPath(dataPath).homePath(this._resolveHomePath(workPath)).workPath(workPath).build();
    }

    private Path _resolveHomePath(Path path) {
        Path absoluteSidecarHomePath;
        Path relativeSidecarHomePath;
        String sidecarHome = this.elasticsearchConfigurationWrapper.sidecarHome();
        if (sidecarHome.equals("elasticsearch-sidecar")) {
            String versionNumber = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/sidecar/sidecar.version");
            sidecarHome = sidecarHome + "/" + versionNumber;
        }
        if (!Files.isDirectory(relativeSidecarHomePath = path.resolve(sidecarHome), new LinkOption[0]) && Files.isDirectory(absoluteSidecarHomePath = Paths.get(sidecarHome, new String[0]), new LinkOption[0])) {
            return absoluteSidecarHomePath;
        }
        return relativeSidecarHomePath;
    }
}

