/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.sort;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GeoDistanceSort;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch7.internal.sort.SortTranslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.osgi.service.component.annotations.Component;

@Component(service={SortTranslator.class})
public class DefaultSortTranslator
implements SortTranslator {
    @Override
    public void translate(SearchSourceBuilder searchSourceBuilder, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>();
        for (Sort sort : sorts) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = this._getSortFieldName(sort, "_score"))) continue;
            sortFieldNames.add(sortFieldName);
            searchSourceBuilder.sort(this._getSortBuilder(sort, sortFieldName));
        }
    }

    private SortBuilder<?> _getFieldSortBuilder(Sort sort, String fieldName) {
        FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)fieldName);
        fieldSortBuilder.unmappedType("keyword");
        if (sort.isReverse()) {
            fieldSortBuilder.order(SortOrder.DESC);
        }
        return fieldSortBuilder;
    }

    private SortBuilder<?> _getGeoDistanceSortBuilder(Sort sort, String fieldName) {
        GeoDistanceSort geoDistanceSort = (GeoDistanceSort)sort;
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        for (GeoLocationPoint geoLocationPoint : geoDistanceSort.getGeoLocationPoints()) {
            geoPoints.add(new GeoPoint(geoLocationPoint.getLatitude(), geoLocationPoint.getLongitude()));
        }
        GeoDistanceSortBuilder geoDistanceSortBuilder = SortBuilders.geoDistanceSort((String)fieldName, (GeoPoint[])geoPoints.toArray(new GeoPoint[0]));
        geoDistanceSortBuilder.geoDistance(GeoDistance.ARC);
        List geoHashes = geoDistanceSort.getGeoHashes();
        if (!geoHashes.isEmpty()) {
            geoDistanceSort.addGeoHash(geoHashes.toArray(new String[0]));
        }
        if (sort.isReverse()) {
            geoDistanceSortBuilder.order(SortOrder.DESC);
        }
        return geoDistanceSortBuilder;
    }

    private SortBuilder<?> _getNestedFieldSortBuilder(Sort sort, String sortFieldName) {
        String[] parts = StringUtil.split((String)sortFieldName, (String)"#");
        String sortField = parts[0];
        FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)sortField);
        if (sort.isReverse()) {
            fieldSortBuilder.order(SortOrder.DESC);
        }
        NestedSortBuilder nestedSortBuilder = new NestedSortBuilder("nestedFieldArray");
        String fieldName = parts[1];
        nestedSortBuilder.setFilter((QueryBuilder)QueryBuilders.termQuery((String)"nestedFieldArray.fieldName", (String)fieldName));
        fieldSortBuilder.setNestedSort(nestedSortBuilder);
        return fieldSortBuilder;
    }

    private SortBuilder<?> _getScoreSortBuilder(Sort sort) {
        ScoreSortBuilder sortBuilder = SortBuilders.scoreSort();
        if (sort.isReverse()) {
            sortBuilder.order(SortOrder.ASC);
        }
        return sortBuilder;
    }

    private SortBuilder<?> _getSortBuilder(Sort sort, String fieldName) {
        if (fieldName.equals("_score")) {
            return this._getScoreSortBuilder(sort);
        }
        if (sort.getType() == 10) {
            return this._getGeoDistanceSortBuilder(sort, fieldName);
        }
        if (fieldName.startsWith("nestedFieldArray.")) {
            return this._getNestedFieldSortBuilder(sort, fieldName);
        }
        return this._getFieldSortBuilder(sort, fieldName);
    }

    private String _getSortFieldName(Sort sort, String scoreFieldName) {
        String sortFieldName = sort.getFieldName();
        if (Objects.equals(sortFieldName, "priority") || Objects.equals(sortFieldName, "_score")) {
            return sortFieldName;
        }
        if (sortFieldName != null && sortFieldName.startsWith("nestedFieldArray.")) {
            return sortFieldName;
        }
        return Field.getSortFieldName((Sort)sort, (String)scoreFieldName);
    }
}

