/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.util;

import java.util.ArrayList;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class QueryUtil {
    public static Integer maxTermsCount = 65536;

    public static AbstractQueryBuilder<? extends AbstractQueryBuilder<?>> translateTerms(String field, String[] terms) {
        if (terms.length <= maxTermsCount) {
            return QueryBuilders.termsQuery((String)field, (String[])terms);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ArrayList<String> termsList = new ArrayList<String>();
        for (String term : terms) {
            termsList.add(term);
            if (termsList.size() != maxTermsCount.intValue()) continue;
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)field, (String[])termsList.toArray(new String[0])));
            termsList.clear();
        }
        if (!termsList.isEmpty()) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)field, (String[])termsList.toArray(new String[0])));
        }
        return boolQueryBuilder;
    }
}

