/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.internal.util.BundleSupportUtil;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

@Parameters(commandDescription="Delete a file from the deploy directory of a Liferay bundle.", commandNames={"clean"})
public class CleanCommand
extends BaseCommand {
    @Parameter(description="The name of the file to delete from your bundle.", names={"-f", "--file"}, required=true)
    private String _fileName;

    @Override
    public void execute() throws IOException {
        String fileName = FileUtil.getFileName(this._fileName);
        String extension = FileUtil.getExtension(fileName);
        String deployFolder = BundleSupportUtil.getDeployFolder(extension);
        File file = new File(this.getLiferayHomeDir(), deployFolder + fileName);
        Files.deleteIfExists(file.toPath());
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }
}

