/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.internal.util.BundleSupportUtil;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import java.io.File;
import java.nio.file.NoSuchFileException;

@Parameters(commandDescription="Deploy a file to a Liferay bundle.", commandNames={"deploy"})
public class DeployCommand
extends BaseCommand {
    @Parameter(converter=FileConverter.class, description="The file to deploy to your Liferay bundle.", names={"-f", "--file"}, required=true)
    private File _file;
    @Parameter(description="The name of the output file.", names={"-o", "--output"})
    private String _outputFileName;

    @Override
    public void execute() throws Exception {
        if (!this._file.exists()) {
            throw new NoSuchFileException("Unable to find " + this._file.getAbsolutePath());
        }
        String fileName = this._file.getName();
        String extension = FileUtil.getExtension(fileName);
        String deployFolder = BundleSupportUtil.getDeployFolder(extension);
        if (this._outputFileName == null) {
            this._outputFileName = this._file.getName();
        }
        File outputFile = new File(this.getLiferayHomeDir(), deployFolder + this._outputFileName);
        FileUtil.copyFile(this._file, outputFile);
    }

    public File getFile() {
        return this._file;
    }

    public String getOutputFileName() {
        return this._outputFileName;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setOutputFileName(String outputFileName) {
        this._outputFileName = outputFileName;
    }
}

