/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;

@Parameters(commandDescription="Download and expand a new bundle.", commandNames={"initBundle"})
public class InitBundleCommand
extends BaseCommand {
    private static final File _BUNDLES_CACHE = new File(System.getProperty("user.home"), ".liferay/bundles");
    private static final int _DEFAULT_STRIP_COMPONENTS = 1;
    private static final String _DEFAULT_URL = "https://sourceforge.net/projects/lportal/files/Liferay%20Portal/7.0.2%20GA3/liferay-ce-portal-tomcat-7.0-ga3-20160804222206210.zip";
    @Parameter(converter=FileConverter.class, description="The directory that contains the configuration files.", names={"--configs"})
    private File _configsDir;
    private File _downloadFile;
    private String _downloadFileName;
    @Parameter(description="The environment of your Liferay home deployment.", names={"--environment"})
    private String _environment;
    @Parameter(description="The password if your URL requires authentication.", names={"-p", "--password"}, password=true)
    private String _password;
    @Parameter(description="The host name of your proxy.", names={"--proxy-host"})
    private String _proxyHost;
    @Parameter(description="The password if your proxy requires authentication.", names={"--proxy-password"}, password=true)
    private String _proxyPassword;
    @Parameter(description="The port of your proxy.", names={"--proxy-port"})
    private int _proxyPort;
    @Parameter(description="The protocol of your proxy.", names={"--proxy-protocol"})
    private String _proxyProtocol;
    @Parameter(description="The user name if your proxy requires authentication.", names={"--proxy-username"})
    private String _proxyUsername;
    @Parameter(description="The number of directories to strip when expanding your bundle.", names={"--strip-components"})
    private int _stripComponents = 1;
    @Parameter(description="The URL of the Liferay Bundle to expand.", names={"--url"})
    private String _url = "https://sourceforge.net/projects/lportal/files/Liferay%20Portal/7.0.2%20GA3/liferay-ce-portal-tomcat-7.0-ga3-20160804222206210.zip";
    @Parameter(description="The user name if your URL requires authentication.", names={"-u", "--username"})
    private String _username;

    @Override
    public void execute() throws Exception {
        this.deleteBundle();
        this.downloadFile();
        this.unpack();
        this.copyConfigs();
    }

    public File getConfigsDir() {
        return this._configsDir;
    }

    public String getEnvironment() {
        return this._environment;
    }

    public String getPassword() {
        return this._password;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public String getProxyPassword() {
        return this._proxyPassword;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public String getProxyProtocol() {
        return this._proxyProtocol;
    }

    public String getProxyUsername() {
        return this._proxyUsername;
    }

    public int getStripComponents() {
        return this._stripComponents;
    }

    public String getUrl() {
        return this._url;
    }

    public String getUsername() {
        return this._username;
    }

    public void setConfigsDir(File configsDir) {
        this._configsDir = configsDir;
    }

    public void setEnvironment(String environment) {
        this._environment = environment;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public void setProxyPassword(String proxyPassword) {
        this._proxyPassword = proxyPassword;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    public void setProxyProtocol(String proxyProtocol) {
        this._proxyProtocol = proxyProtocol;
    }

    public void setProxyUsername(String proxyUsername) {
        this._proxyUsername = proxyUsername;
    }

    public void setStripComponents(int stripComponents) {
        this._stripComponents = stripComponents;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    protected void copyConfigs() throws IOException {
        File configsEnvDir;
        if (this._configsDir == null || !this._configsDir.exists()) {
            return;
        }
        File configsCommonDir = new File(this._configsDir, "common");
        if (configsCommonDir.exists()) {
            FileUtil.copyDirectory(configsCommonDir, this.getLiferayHomeDir());
        }
        if ((configsEnvDir = new File(this._configsDir, this._environment)).exists()) {
            FileUtil.copyDirectory(configsEnvDir, this.getLiferayHomeDir());
        }
    }

    protected void deleteBundle() throws IOException {
        File liferayHomeDir = this.getLiferayHomeDir();
        if (!liferayHomeDir.exists()) {
            return;
        }
        FileUtil.deleteDirectory(liferayHomeDir.toPath());
    }

    protected void downloadFile() throws Exception {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setRedirectsEnabled(true);
        requestConfigBuilder.setCookieSpec("standard");
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this._proxyHost != null) {
            HttpHost proxyHttpHost = new HttpHost(this._proxyHost, this._proxyPort, this._proxyProtocol);
            requestConfigBuilder.setProxy(proxyHttpHost);
            if (this._proxyUsername != null) {
                credentialsProvider.setCredentials(new AuthScope(this._proxyHost, this._proxyPort), new UsernamePasswordCredentials(this._proxyUsername, this._proxyPassword));
            }
        }
        try (CloseableHttpClient closeableHttpClient = httpClientBuilder.build();){
            URI uri = new URI(this._url);
            HttpHead httpHead = new HttpHead(uri);
            BasicHttpContext httpContext = new BasicHttpContext();
            if (this._username != null && this._password != null) {
                credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), new UsernamePasswordCredentials(this._username, this._password));
            }
            Date lastModified = null;
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpHead, httpContext);){
                Header dispositionHeader = closeableHttpResponse.getFirstHeader("Content-Disposition");
                if (dispositionHeader != null) {
                    String dispositionValue = dispositionHeader.getValue();
                    int index = dispositionValue.indexOf("filename=");
                    if (index > 0) {
                        this._downloadFileName = dispositionValue.substring(index + 10, dispositionValue.length() - 1);
                    }
                } else {
                    RedirectLocations redirectLocations = (RedirectLocations)httpContext.getAttribute("http.protocol.redirect-locations");
                    if (redirectLocations != null) {
                        List<URI> redirectLocationsList = redirectLocations.getAll();
                        uri = redirectLocationsList.get(redirectLocationsList.size() - 1);
                    }
                    this._downloadFileName = this.getDownloadFileName(uri);
                }
                Header lastModifiedHeader = closeableHttpResponse.getFirstHeader("Last-Modified");
                if (lastModifiedHeader != null) {
                    String lastModifiedValue = lastModifiedHeader.getValue();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    lastModified = dateFormat.parse(lastModifiedValue);
                } else {
                    lastModified = new Date();
                }
            }
            this._downloadFile = new File(_BUNDLES_CACHE, this._downloadFileName);
            if (this._downloadFile.exists() && this._downloadFile.lastModified() == lastModified.getTime()) {
                return;
            }
            if (this._downloadFile.exists()) {
                this._downloadFile.delete();
            }
            if (!_BUNDLES_CACHE.exists()) {
                _BUNDLES_CACHE.mkdirs();
            }
            this._downloadFile.createNewFile();
            HttpGet httpGet = new HttpGet(uri);
            try (FileOutputStream fileOutputStream = new FileOutputStream(this._downloadFile);
                 CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpGet);){
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                fileOutputStream.write(EntityUtils.toByteArray(httpEntity));
                this._downloadFile.setLastModified(lastModified.getTime());
            }
        }
    }

    protected String getDownloadFileName(URI uri) {
        String fileName = uri.getPath();
        int index = fileName.lastIndexOf("/") + 1;
        fileName = fileName.substring(index);
        return fileName;
    }

    protected void unpack() throws Exception {
        String extension = FileUtil.getExtension(this._downloadFile.getName());
        if (extension.equals("zip")) {
            FileUtil.unzip(this._downloadFile, this.getLiferayHomePath(), this._stripComponents);
        } else if (extension.equals("gz") || extension.equals("tar") || extension.equals("tar.gz") || extension.equals("tgz")) {
            FileUtil.untar(this._downloadFile, this.getLiferayHomePath(), this._stripComponents);
        }
    }
}

