/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@Parameters(commandDescription="Turn a Liferay home into an distributable archive.", commandNames={"distBundle"})
public class DistBundleCommand
extends BaseCommand {
    private static final String _DEFAULT_FORMAT = "zip";
    @Parameter(description="The archive format.", names={"--format"})
    private String _format = "zip";
    @Parameter(description="Add a parent folder to the archive.", names={"--include-folder"})
    private boolean _includeFolder;
    @Parameter(description="The path of the archive.", names={"-o", "--output"}, required=true)
    private File _outputFile;

    @Override
    public void execute() throws Exception {
        if (this._outputFile.exists()) {
            this._outputFile.delete();
        }
        Path outputPath = this._outputFile.toPath();
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        if (this._format.equals(_DEFAULT_FORMAT)) {
            this._distBundleZip();
        } else if (this._format.equals("tar") || this._format.equals("tar.gz") || this._format.equals("tgz")) {
            this._distBundleTar();
        } else {
            throw new IllegalArgumentException("Please specify either zip or tar.gz for format");
        }
    }

    public String getFormat() {
        return this._format;
    }

    public File getOutputFile() {
        return this._outputFile;
    }

    public boolean isIncludeFolder() {
        return this._includeFolder;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public void setIncludeFolder(boolean includeFolder) {
        this._includeFolder = includeFolder;
    }

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    private void _distBundleTar() throws Exception {
        FileUtil.tar(this.getLiferayHomePath(), this._outputFile, this._includeFolder);
    }

    private void _distBundleZip() throws Exception {
        FileUtil.zip(this.getLiferayHomePath(), this._outputFile, this._includeFolder);
    }
}

