/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.internal.util;

import com.liferay.portal.tools.bundle.support.BundleSupport;
import com.liferay.portal.tools.bundle.support.util.StreamLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.protocol.BasicHttpContext;

public class FileUtil {
    private static final long _FILE_LENGTH_KB = 1024L;
    private static final long _FILE_LENGTH_MB = 0x100000L;

    public static void appendTar(File entryFile, Path entryPath, File tarFile) throws IOException {
        try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(new GzipCompressorOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            FileUtil._appendTar(entryFile, entryPath, tarArchiveOutputStream);
        }
    }

    public static void appendZip(File entryFile, Path entryPath, File zipFile) throws Exception {
        try (FileSystem fileSystem = FileUtil._createFileSystem(zipFile.toPath(), false);){
            FileUtil._appendZip(entryFile, entryPath, fileSystem);
        }
    }

    public static void copyDirectory(final Path dirPath, final Path destinationDirPath) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Path relativePath = dirPath.relativize(path);
                Path destinationPath = destinationDirPath.resolve(relativePath);
                FileUtil.copyFile(path, destinationPath);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copyFile(Path path, Path destinationPath) throws IOException {
        Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
        Files.copy(path, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        Files.setLastModifiedTime(destinationPath, Files.getLastModifiedTime(path, new LinkOption[0]));
    }

    public static void deleteDirectory(Path dirPath) throws IOException {
        if (Files.notExists(dirPath, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException ioe) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path downloadFile(URI uri, String userName, String password, Path cacheDirPath, StreamLogger streamLogger) throws Exception {
        Path path;
        try (CloseableHttpClient closeableHttpClient = FileUtil._getHttpClient(uri, userName, password);){
            Date lastModifiedDate;
            HttpHead httpHead = new HttpHead(uri);
            BasicHttpContext httpContext = new BasicHttpContext();
            String fileName = null;
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpHead, httpContext);
            Object object = null;
            try {
                FileUtil._checkResponseStatus(closeableHttpResponse);
                Header dispositionHeader = closeableHttpResponse.getFirstHeader("Content-Disposition");
                if (dispositionHeader != null) {
                    String dispositionValue = dispositionHeader.getValue();
                    int index = dispositionValue.indexOf("filename=");
                    if (index > 0) {
                        fileName = dispositionValue.substring(index + 10, dispositionValue.length() - 1);
                    }
                } else {
                    RedirectLocations redirectLocations = (RedirectLocations)httpContext.getAttribute("http.protocol.redirect-locations");
                    if (redirectLocations != null) {
                        uri = redirectLocations.get(redirectLocations.size() - 1);
                    }
                }
                Header lastModifiedHeader = closeableHttpResponse.getFirstHeader("Last-Modified");
                if (lastModifiedHeader != null) {
                    String lastModifiedValue = lastModifiedHeader.getValue();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    lastModifiedDate = dateFormat.parse(lastModifiedValue);
                } else {
                    lastModifiedDate = new Date();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (closeableHttpResponse != null) {
                    if (object != null) {
                        try {
                            closeableHttpResponse.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        closeableHttpResponse.close();
                    }
                }
            }
            if (fileName == null) {
                String uriPath = uri.getPath();
                fileName = uriPath.substring(uriPath.lastIndexOf(47) + 1);
            }
            if (cacheDirPath == null) {
                cacheDirPath = Files.createTempDirectory(null, new FileAttribute[0]);
            }
            if (Files.exists(path = cacheDirPath.resolve(fileName), new LinkOption[0])) {
                FileTime fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                if (fileTime.toMillis() == lastModifiedDate.getTime()) {
                    object = path;
                    return object;
                }
                Files.delete(path);
            }
            Files.createDirectories(cacheDirPath, new FileAttribute[0]);
            HttpGet httpGet = new HttpGet(uri);
            try (CloseableHttpResponse closeableHttpResponse2 = closeableHttpClient.execute(httpGet);){
                FileUtil._checkResponseStatus(closeableHttpResponse2);
                HttpEntity httpEntity = closeableHttpResponse2.getEntity();
                long length = httpEntity.getContentLength();
                streamLogger.onStarted();
                try (InputStream inputStream = httpEntity.getContent();
                     OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                    byte[] buffer = new byte[10240];
                    int completed = 0;
                    int read = -1;
                    while ((read = inputStream.read(buffer)) >= 0) {
                        outputStream.write(buffer, 0, read);
                        streamLogger.onProgress(completed += read, length);
                    }
                }
                finally {
                    streamLogger.onCompleted();
                }
            }
            Files.setLastModifiedTime(path, FileTime.fromMillis(lastModifiedDate.getTime()));
        }
        return path;
    }

    public static String getFileLength(long length) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        if (length > 0x100000L) {
            return decimalFormat.format((double)length / 1048576.0) + " MB";
        }
        if (length > 1024L) {
            return decimalFormat.format((double)length / 1024.0) + " KB";
        }
        return decimalFormat.format(length) + " B";
    }

    public static File getJarFile() throws Exception {
        ProtectionDomain protectionDomain = BundleSupport.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        return new File(url.toURI());
    }

    public static void tar(Path sourcePath, File tarFile, boolean includeFolder) throws Exception {
        final Path parentPath = includeFolder ? sourcePath.getParent() : sourcePath;
        try (final TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(new GzipCompressorOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path entryPath = parentPath.relativize(path);
                    FileUtil._appendTar(path.toFile(), entryPath, tarArchiveOutputStream);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void unpack(Path path, Path destinationDirPath, int stripComponents) throws Exception {
        String fileName = String.valueOf(path.getFileName());
        if (fileName.endsWith(".gz") || fileName.endsWith(".tar") || fileName.endsWith(".tgz")) {
            FileUtil._untar(path, destinationDirPath, stripComponents);
        } else if (fileName.endsWith(".zip")) {
            FileUtil._unzip(path, destinationDirPath, stripComponents);
        } else {
            throw new UnsupportedOperationException("Unsupported format for " + fileName);
        }
    }

    public static void zip(Path sourcePath, File zipFile, boolean includeFolder) throws Exception {
        final Path parentPath = includeFolder ? sourcePath.getParent() : sourcePath;
        try (final FileSystem fileSystem = FileUtil._createFileSystem(zipFile.toPath(), true);){
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path entryPath = parentPath.relativize(path);
                    FileUtil.copyFile(path, fileSystem.getPath(entryPath.toString(), new String[0]));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void _appendTar(File entryFile, Path entryPath, TarArchiveOutputStream tarArchiveOutputStream) throws IOException {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(entryPath.toFile());
        tarArchiveEntry.setSize(entryFile.length());
        tarArchiveOutputStream.putArchiveEntry(tarArchiveEntry);
        IOUtils.copy(new FileInputStream(entryFile), tarArchiveOutputStream);
        tarArchiveOutputStream.closeArchiveEntry();
    }

    private static void _appendZip(File entryFile, Path entryPath, FileSystem fileSystem) throws IOException {
        Path zipPath = fileSystem.getPath(entryPath.toString(), new String[0]);
        FileUtil.copyFile(entryFile.toPath(), zipPath);
    }

    private static void _checkResponseStatus(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException(statusLine.getReasonPhrase());
        }
    }

    private static FileSystem _createFileSystem(Path path, boolean create) throws Exception {
        URI uri = path.toUri();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("create", Boolean.toString(create));
        properties.put("encoding", StandardCharsets.UTF_8.name());
        return FileSystems.newFileSystem(new URI("jar:" + uri.getScheme(), uri.getPath(), null), properties);
    }

    private static CloseableHttpClient _getHttpClient(URI uri, String userName, String password) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec("standard");
        requestConfigBuilder.setRedirectsEnabled(true);
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        if (userName != null && password != null) {
            credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), new UsernamePasswordCredentials(userName, password));
        }
        String scheme = uri.getScheme();
        String proxyHost = System.getProperty(scheme + ".proxyHost");
        String proxyPort = System.getProperty(scheme + ".proxyPort");
        String proxyUser = System.getProperty(scheme + ".proxyUser");
        String proxyPassword = System.getProperty(scheme + ".proxyPassword");
        if (proxyHost != null && proxyPort != null && proxyUser != null && proxyPassword != null) {
            credentialsProvider.setCredentials(new AuthScope(proxyHost, Integer.parseInt(proxyPort)), new UsernamePasswordCredentials(proxyUser, proxyPassword));
        }
        httpClientBuilder.useSystemProperties();
        return httpClientBuilder.build();
    }

    private static void _untar(Path tarPath, Path destinationDirPath, int stripComponents) throws IOException {
        try (InputStream inputStream = Files.newInputStream(tarPath, new OpenOption[0]);
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(new GzipCompressorInputStream(inputStream));){
            TarArchiveEntry tarArchiveEntry = null;
            while ((tarArchiveEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
                if (tarArchiveEntry.isDirectory()) continue;
                Path destinationPath = Paths.get(tarArchiveEntry.getName(), new String[0]);
                destinationPath = destinationDirPath.resolve(destinationPath.subpath(stripComponents, destinationPath.getNameCount()));
                Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
                Files.copy(tarArchiveInputStream, destinationPath, new CopyOption[0]);
                Date lastModifiedDate = tarArchiveEntry.getLastModifiedDate();
                Files.setLastModifiedTime(destinationPath, FileTime.fromMillis(lastModifiedDate.getTime()));
            }
        }
    }

    private static void _unzip(Path zipPath, final Path destinationDirPath, final int stripComponents) throws Exception {
        try (FileSystem fileSystem = FileUtil._createFileSystem(zipPath, false);){
            Files.walkFileTree(fileSystem.getPath("/", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path relativePath = path.subpath(stripComponents, path.getNameCount());
                    Path destinationPath = destinationDirPath.resolve(relativePath.toString());
                    FileUtil.copyFile(path, destinationPath);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

