/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import com.liferay.portal.tools.bundle.support.util.StreamLogger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Parameters(commandDescription="Download and expand a new bundle.", commandNames={"initBundle"})
public class InitBundleCommand
extends BaseCommand
implements StreamLogger {
    private static final int _DEFAULT_STRIP_COMPONENTS = 1;
    private static final URL _DEFAULT_URL;
    @Parameter(description="The directory where to cache the downloaded bundles.", names={"--cache-dir"})
    private File _cacheDir = new File(System.getProperty("user.home"), ".liferay/bundles");
    @Parameter(description="The directory that contains the configuration files.", names={"--configs"})
    private File _configsDir;
    @Parameter(description="The environment of your Liferay home deployment.", names={"--environment"})
    private String _environment;
    @Parameter(description="The password if your URL requires authentication.", names={"-p", "--password"}, password=true)
    private String _password;
    @Parameter(description="The number of directories to strip when expanding your bundle.", names={"--strip-components"})
    private int _stripComponents = 1;
    @Parameter(description="The URL of the Liferay Bundle to expand.", names={"--url"})
    private URL _url = _DEFAULT_URL;
    @Parameter(description="The user name if your URL requires authentication.", names={"-u", "--username", "--user-name"})
    private String _userName;

    @Override
    public void execute() throws Exception {
        this._deleteBundle();
        Path cacheDirPath = null;
        if (this._cacheDir != null) {
            cacheDirPath = this._cacheDir.toPath();
        }
        Path path = FileUtil.downloadFile(this._url.toURI(), this._userName, this._password, cacheDirPath, this);
        FileUtil.unpack(path, this.getLiferayHomePath(), this._stripComponents);
        this._copyConfigs();
    }

    public File getCacheDir() {
        return this._cacheDir;
    }

    public File getConfigsDir() {
        return this._configsDir;
    }

    public String getEnvironment() {
        return this._environment;
    }

    public String getPassword() {
        return this._password;
    }

    public int getStripComponents() {
        return this._stripComponents;
    }

    public URL getUrl() {
        return this._url;
    }

    public String getUserName() {
        return this._userName;
    }

    @Override
    public void onCompleted() {
        System.out.println();
    }

    @Override
    public void onProgress(long completed, long length) {
        StringBuilder sb = new StringBuilder();
        sb.append(FileUtil.getFileLength(completed));
        if (length > 0L) {
            sb.append('/');
            sb.append(FileUtil.getFileLength(length));
        }
        sb.append(" downloaded");
        this.onProgress(sb.toString());
    }

    @Override
    public void onStarted() {
        this.onStarted("Download " + this._url);
    }

    public void setCacheDir(File cacheDir) {
        this._cacheDir = cacheDir;
    }

    public void setConfigsDir(File configsDir) {
        this._configsDir = configsDir;
    }

    public void setEnvironment(String environment) {
        this._environment = environment;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setStripComponents(int stripComponents) {
        this._stripComponents = stripComponents;
    }

    public void setUrl(URL url) {
        this._url = url;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    protected void onProgress(String message) {
        System.out.print("\r" + message);
    }

    protected void onStarted(String message) {
        System.out.println(message);
    }

    private void _copyConfigs() throws IOException {
        Path configsEnvironmentDirPath;
        if (this._configsDir == null || !this._configsDir.exists()) {
            return;
        }
        Path configsDirPath = this._configsDir.toPath();
        Path configsCommonDirPath = configsDirPath.resolve("common");
        if (Files.exists(configsCommonDirPath, new LinkOption[0])) {
            FileUtil.copyDirectory(configsCommonDirPath, this.getLiferayHomePath());
        }
        if (Files.exists(configsEnvironmentDirPath = configsDirPath.resolve(this._environment), new LinkOption[0])) {
            FileUtil.copyDirectory(configsEnvironmentDirPath, this.getLiferayHomePath());
        }
    }

    private void _deleteBundle() throws IOException {
        Path dirPath = this.getLiferayHomePath();
        if (Files.exists(dirPath, new LinkOption[0])) {
            FileUtil.deleteDirectory(dirPath);
        }
    }

    static {
        try {
            _DEFAULT_URL = new URL("https://cdn.lfrs.sl/releases.liferay.com/portal/7.0.2-ga3/liferay-ce-portal-tomcat-7.0-ga3-20160804222206210.zip");
        }
        catch (MalformedURLException murle) {
            throw new ExceptionInInitializerError(murle);
        }
    }
}

