/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.maven;

import com.liferay.portal.tools.bundle.support.commands.DistBundleCommand;
import com.liferay.portal.tools.bundle.support.commands.InitBundleCommand;
import com.liferay.portal.tools.bundle.support.internal.util.BundleSupportUtil;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import com.liferay.portal.tools.bundle.support.internal.util.MavenUtil;
import com.liferay.portal.tools.bundle.support.maven.AbstractBundleMojo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="dist")
public class DistBundleMojo
extends AbstractBundleMojo {
    @Parameter
    protected String archiveFileName;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}", required=true)
    protected File deployFile;
    @Parameter(defaultValue="zip", required=true)
    protected String format;
    @Parameter(defaultValue="true", required=true)
    protected boolean includeFolder;
    @Parameter(defaultValue="${project.artifactId}.${project.packaging}", required=true)
    protected String outputFileName;

    public void execute() throws MojoExecutionException {
        MavenProject rootProject = MavenUtil.getRootProject(this.project);
        Build build = rootProject.getBuild();
        if (this.archiveFileName == null) {
            this.archiveFileName = rootProject.getArtifactId();
        }
        String archiveLocation = build.getDirectory() + "/" + this.archiveFileName;
        this.setLiferayHome(archiveLocation);
        File archive = new File(archiveLocation + "." + this.format);
        String packaging = this.project.getPackaging();
        if (packaging.equals("jar") || packaging.equals("war")) {
            try {
                String deployDirName = BundleSupportUtil.getDeployDirName(this.deployFile.getName());
                if (this.includeFolder) {
                    deployDirName = this.archiveFileName + "/" + deployDirName;
                }
                Path entryPath = Paths.get(deployDirName, this.outputFileName);
                if (this.format.equals("zip")) {
                    FileUtil.appendZip(this.deployFile, entryPath, archive);
                }
                if (this.format.equals("gz") || this.format.equals("tar") || this.format.equals("tar.gz") || this.format.equals("tgz")) {
                    FileUtil.appendTar(this.deployFile, entryPath, archive);
                }
                throw new IllegalArgumentException("Please specify either zip or tar.gz or tgz");
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to create distributable bundle", e);
            }
        } else if (!this.project.hasParent()) {
            try {
                archive.delete();
                File liferayHomeDir = this.getLiferayHomeDir();
                InitBundleCommand initBundleCommand = new InitBundleCommand();
                initBundleCommand.setConfigsDir(new File(this.project.getBasedir(), this.configs));
                initBundleCommand.setEnvironment(this.environment);
                initBundleCommand.setLiferayHomeDir(liferayHomeDir);
                initBundleCommand.setPassword(this.password);
                initBundleCommand.setStripComponents(this.stripComponents);
                initBundleCommand.setUrl(this.url);
                initBundleCommand.setUserName(this.userName);
                initBundleCommand.execute();
                DistBundleCommand distBundleCommand = new DistBundleCommand();
                distBundleCommand.setFormat(this.format);
                distBundleCommand.setIncludeFolder(this.includeFolder);
                distBundleCommand.setLiferayHomeDir(this.getLiferayHomeDir());
                distBundleCommand.setOutputFile(archive);
                distBundleCommand.execute();
                FileUtil.deleteDirectory(liferayHomeDir.toPath());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to create distributable bundle", e);
            }
        }
    }
}

