/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.maven;

import com.liferay.portal.tools.bundle.support.commands.InitBundleCommand;
import com.liferay.portal.tools.bundle.support.internal.util.BundleSupportUtil;
import com.liferay.portal.tools.bundle.support.internal.util.MavenUtil;
import com.liferay.portal.tools.bundle.support.maven.AbstractBundleMojo;
import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;

@Mojo(inheritByDefault=false, name="init")
public class InitBundleMojo
extends AbstractBundleMojo {
    @Parameter(property="session", readonly=true)
    private MavenSession _mavenSession;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        if (this.project.hasParent()) {
            return;
        }
        Proxy proxy = MavenUtil.getProxy(this._mavenSession);
        String proxyProtocol = this.url.getProtocol();
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUser = null;
        String proxyPassword = null;
        String nonProxyHosts = null;
        if (proxy != null) {
            proxyHost = BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyHost", proxy.getHost());
            proxyPort = BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPort", proxy.getPort());
            proxyUser = BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyUser", proxy.getUsername());
            proxyPassword = BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPassword", proxy.getPassword());
            nonProxyHosts = BundleSupportUtil.setSystemProperty(proxyProtocol + ".nonProxyHosts", proxy.getNonProxyHosts());
        }
        try {
            InitBundleCommand initBundleCommand = new InitBundleCommand();
            initBundleCommand.setConfigsDir(new File(this.project.getBasedir(), this.configs));
            initBundleCommand.setEnvironment(this.environment);
            initBundleCommand.setLiferayHomeDir(this.getLiferayHomeDir());
            initBundleCommand.setPassword(this.password);
            initBundleCommand.setStripComponents(this.stripComponents);
            initBundleCommand.setUrl(this.url);
            initBundleCommand.setUserName(this.userName);
            initBundleCommand.execute();
            if (proxy == null) return;
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Unable to initialize bundle", e);
            }
            catch (Throwable throwable) {
                if (proxy == null) throw throwable;
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyHost", proxyHost);
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPort", proxyPort);
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyUser", proxyUser);
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPassword", proxyPassword);
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".nonProxyHosts", nonProxyHosts);
                throw throwable;
            }
        }
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyHost", proxyHost);
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPort", proxyPort);
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyUser", proxyUser);
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPassword", proxyPassword);
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".nonProxyHosts", nonProxyHosts);
        return;
    }
}

