/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import com.liferay.portal.tools.bundle.support.internal.util.HttpUtil;
import com.liferay.portal.tools.bundle.support.util.StreamLogger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Set;

@Parameters(commandDescription="Download and expand a new bundle.", commandNames={"initBundle"})
public class InitBundleCommand
extends BaseCommand
implements StreamLogger {
    private static final URL _DEFAULT_URL;
    private static final Set<PosixFilePermission> _shPosixFilePermissions;
    @Parameter(description="The directory where to cache the downloaded bundles.", names={"--cache-dir"})
    private File _cacheDir = new File(System.getProperty("user.home"), ".liferay/bundles");
    @Parameter(description="The directory that contains the configuration files.", names={"--configs"})
    private File _configsDir;
    @Parameter(description="The environment of your Liferay home deployment.", names={"--environment"})
    private String _environment = "local";
    @Parameter(description="The password if your URL requires authentication.", names={"-p", "--password"}, password=true)
    private String _password;
    @Parameter(description="The number of directories to strip when expanding your bundle.", names={"--strip-components"})
    private int _stripComponents = 1;
    @Parameter(description="Use token authentication.", names={"-t", "--token"})
    private boolean _token;
    @Parameter(description="The file where your liferay.com download token is stored.", names={"--token-file"})
    private File _tokenFile = BundleSupportConstants.DEFAULT_TOKEN_FILE;
    @Parameter(description="The URL of the Liferay Bundle to expand.", names={"--url"})
    private URL _url = _DEFAULT_URL;
    @Parameter(description="The user name if your URL requires authentication.", names={"-u", "--username", "--user-name"})
    private String _userName;

    @Override
    public void execute() throws Exception {
        Path path;
        URI uri;
        this._deleteBundle();
        Path cacheDirPath = null;
        if (this._cacheDir != null) {
            cacheDirPath = this._cacheDir.toPath();
        }
        if ("file".equals((uri = this._url.toURI()).getScheme())) {
            path = Paths.get(uri);
        } else if (this._token) {
            String tokenContent = FileUtil.read(this._tokenFile);
            tokenContent = tokenContent.trim();
            path = HttpUtil.downloadFile(uri, tokenContent, cacheDirPath, this);
        } else {
            path = HttpUtil.downloadFile(uri, this._userName, this._password, cacheDirPath, this);
        }
        File liferayHomeDir = this.getLiferayHomeDir();
        FileUtil.unpack(path, liferayHomeDir.toPath(), this._stripComponents);
        this._copyConfigs();
        this._fixPosixFilePermissions();
    }

    public File getCacheDir() {
        return this._cacheDir;
    }

    public File getConfigsDir() {
        return this._configsDir;
    }

    public String getEnvironment() {
        return this._environment;
    }

    public String getPassword() {
        return this._password;
    }

    public int getStripComponents() {
        return this._stripComponents;
    }

    public File getTokenFile() {
        return this._tokenFile;
    }

    public URL getUrl() {
        return this._url;
    }

    public String getUserName() {
        return this._userName;
    }

    public boolean isToken() {
        return this._token;
    }

    @Override
    public void onCompleted() {
        System.out.println();
    }

    @Override
    public void onProgress(long completed, long length) {
        StringBuilder sb = new StringBuilder();
        sb.append(FileUtil.getFileLength(completed));
        if (length > 0L) {
            sb.append('/');
            sb.append(FileUtil.getFileLength(length));
        }
        sb.append(" downloaded");
        this.onProgress(sb.toString());
    }

    @Override
    public void onStarted() {
        this.onStarted("Download " + this._url);
    }

    public void setCacheDir(File cacheDir) {
        this._cacheDir = cacheDir;
    }

    public void setConfigsDir(File configsDir) {
        this._configsDir = configsDir;
    }

    public void setEnvironment(String environment) {
        this._environment = environment;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setStripComponents(int stripComponents) {
        this._stripComponents = stripComponents;
    }

    public void setToken(boolean token) {
        this._token = token;
    }

    public void setTokenFile(File tokenFile) {
        this._tokenFile = tokenFile;
    }

    public void setUrl(URL url) {
        this._url = url;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    protected void onProgress(String message) {
        char[] chars = new char[80];
        System.arraycopy(message.toCharArray(), 0, chars, 0, message.length());
        Arrays.fill(chars, message.length(), chars.length - 2, ' ');
        chars[chars.length - 1] = 13;
        System.out.print(chars);
    }

    protected void onStarted(String message) {
        System.out.println(message);
    }

    private void _copyConfigs() throws IOException {
        Path configsEnvironmentDirPath;
        if (this._configsDir == null || !this._configsDir.exists()) {
            return;
        }
        Path configsDirPath = this._configsDir.toPath();
        Path configsCommonDirPath = configsDirPath.resolve("common");
        File liferayHomeDir = this.getLiferayHomeDir();
        Path liferayHomeDirPath = liferayHomeDir.toPath();
        if (Files.exists(configsCommonDirPath, new LinkOption[0])) {
            FileUtil.copyDirectory(configsCommonDirPath, liferayHomeDirPath);
        }
        if (Files.exists(configsEnvironmentDirPath = configsDirPath.resolve(this._environment), new LinkOption[0])) {
            FileUtil.copyDirectory(configsEnvironmentDirPath, liferayHomeDirPath);
        }
    }

    private void _deleteBundle() throws IOException {
        File dir = this.getLiferayHomeDir();
        FileUtil.deleteDirectory(dir.toPath());
    }

    private void _fixPosixFilePermissions() throws IOException {
        File dir = this.getLiferayHomeDir();
        Path dirPath = dir.toPath();
        if (!FileUtil.isPosixSupported(dirPath)) {
            return;
        }
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String fileName = String.valueOf(path.getFileName());
                if (fileName.endsWith(".sh")) {
                    Files.setPosixFilePermissions(path, _shPosixFilePermissions);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        _shPosixFilePermissions = PosixFilePermissions.fromString("rwxr-x---");
        try {
            _DEFAULT_URL = new URL("https://cdn.lfrs.sl/releases.liferay.com/portal/7.0.3-ga4/liferay-ce-portal-tomcat-7.0-ga4-20170613175008905.zip");
        }
        catch (MalformedURLException murle) {
            throw new ExceptionInInitializerError(murle);
        }
    }
}

