/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.maven;

import com.liferay.portal.tools.bundle.support.commands.DeployCommand;
import com.liferay.portal.tools.bundle.support.maven.AbstractLiferayMojo;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(defaultPhase=LifecyclePhase.PACKAGE, name="deploy")
public class DeployMojo
extends AbstractLiferayMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}", required=true)
    protected File deployFile;
    @Parameter(defaultValue="${project.artifactId}.${project.packaging}", required=true)
    protected String outputFileName;

    public void execute() throws MojoExecutionException {
        String packaging = this.project.getPackaging();
        if (!packaging.equals("jar") && !packaging.equals("war")) {
            return;
        }
        try {
            DeployCommand deployCommand = new DeployCommand();
            deployCommand.setFile(this.deployFile);
            deployCommand.setLiferayHomeDir(this.getLiferayHomeDir());
            deployCommand.setOutputFileName(this.outputFileName);
            deployCommand.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to deploy " + this.outputFileName, e);
        }
    }
}

