/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.maven;

import com.liferay.portal.tools.bundle.support.commands.DeployCommand;
import com.liferay.portal.tools.bundle.support.commands.DistBundleCommand;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import com.liferay.portal.tools.bundle.support.internal.util.MavenUtil;
import com.liferay.portal.tools.bundle.support.maven.InitBundleMojo;
import java.io.File;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(defaultPhase=LifecyclePhase.VERIFY, name="dist")
public class DistBundleMojo
extends InitBundleMojo {
    @Parameter
    protected String archiveFileName;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}", required=true)
    protected File deployFile;
    @Parameter(defaultValue="tar.gz", required=true)
    protected String format;
    @Parameter(defaultValue="true", required=true)
    protected boolean includeFolder;
    @Parameter(defaultValue="${project.artifactId}.${project.packaging}", required=true)
    protected String outputFileName;
    @Parameter(property="reactorProjects", readonly=true)
    protected List<MavenProject> reactorProjects;

    @Override
    public void execute() throws MojoExecutionException {
        MavenProject rootProject = MavenUtil.getRootProject(this.project);
        Build build = rootProject.getBuild();
        if (this.archiveFileName == null) {
            this.archiveFileName = rootProject.getArtifactId();
        }
        String archiveLocation = build.getDirectory() + "/" + this.archiveFileName;
        this.setLiferayHome(archiveLocation);
        File archiveFile = new File(archiveLocation + "." + this.format);
        String packaging = this.project.getPackaging();
        try {
            if (packaging.equals("jar") || packaging.equals("war")) {
                try {
                    DeployCommand deployCommand = new DeployCommand();
                    deployCommand.setFile(this.deployFile);
                    deployCommand.setLiferayHomeDir(this.getLiferayHomeDir());
                    deployCommand.setOutputFileName(this.outputFileName);
                    deployCommand.execute();
                }
                catch (Exception exception) {
                    throw new MojoExecutionException("Unable to deploy " + this.outputFileName, exception);
                }
            } else if (!this.project.hasParent()) {
                archiveFile.delete();
                super.execute();
            }
            MavenProject mavenProject = this.reactorProjects.get(this.reactorProjects.size() - 1);
            if (this.project.equals((Object)mavenProject)) {
                DistBundleCommand distBundleCommand = new DistBundleCommand();
                distBundleCommand.setFormat(this.format);
                distBundleCommand.setIncludeFolder(this.includeFolder);
                distBundleCommand.setLiferayHomeDir(this.getLiferayHomeDir());
                distBundleCommand.setOutputFile(archiveFile);
                distBundleCommand.execute();
                File liferayHomeDir = this.getLiferayHomeDir();
                FileUtil.deleteDirectory(liferayHomeDir.toPath());
            }
        }
        catch (MojoExecutionException mojoExecutionException) {
            throw mojoExecutionException;
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Unable to create distributable bundle", exception);
        }
    }
}

