/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sass.compiler.jsass.internal;

import com.liferay.sass.compiler.SassCompiler;
import com.liferay.sass.compiler.jsass.internal.JSassCompilerException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import io.bit3.jsass.context.FileContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.ArrayList;

public class JSassCompiler
implements SassCompiler {
    private static final int _PRECISION_DEFAULT = 5;
    private final int _precision;
    private final String _tmpDirName;

    public JSassCompiler() {
        this(5);
    }

    public JSassCompiler(int precision) {
        this(precision, System.getProperty("java.io.tmpdir"));
    }

    public JSassCompiler(int precision, String tmpDirName) {
        this._precision = precision;
        this._tmpDirName = tmpDirName;
    }

    public String compileFile(String inputFileName, String includeDirName) throws JSassCompilerException {
        return this.compileFile(inputFileName, includeDirName, false, "");
    }

    public String compileFile(String inputFileName, String includeDirName, boolean generateSourceMap) throws JSassCompilerException {
        return this.compileFile(inputFileName, includeDirName, generateSourceMap, "");
    }

    public String compileFile(String inputFileName, String includeDirName, boolean generateSourceMap, String sourceMapFileName) throws JSassCompilerException {
        try {
            Compiler compiler;
            Output output;
            Options options = new Options();
            ArrayList<File> includeDirNames = new ArrayList<File>();
            for (String fileName : includeDirName.split(File.pathSeparator)) {
                File file = new File(fileName);
                includeDirNames.add(file.getCanonicalFile());
            }
            File inputFile = new File(inputFileName);
            includeDirNames.add(inputFile.getParentFile());
            options.setIncludePaths(includeDirNames);
            options.setOutputStyle(OutputStyle.NESTED);
            options.setPrecision(this._precision);
            options.setSourceComments(false);
            if (generateSourceMap) {
                if (sourceMapFileName == null || sourceMapFileName.equals("")) {
                    sourceMapFileName = this.getOutputFileName(inputFileName) + ".map";
                }
                File sourceMapFile = new File(sourceMapFileName);
                options.setSourceMapContents(false);
                options.setSourceMapEmbed(false);
                options.setSourceMapFile(sourceMapFile.toURI());
                options.setOmitSourceMapUrl(false);
            }
            if ((output = (compiler = new Compiler()).compile(new FileContext(inputFile.toURI(), null, options))) == null) {
                throw new JSassCompilerException("Null output");
            }
            if (generateSourceMap) {
                try {
                    this.write(new File(sourceMapFileName), output.getSourceMap());
                }
                catch (Exception e) {
                    System.out.println("Unable to create source map");
                }
            }
            return output.getCss();
        }
        catch (Exception e) {
            throw new JSassCompilerException(e);
        }
    }

    public String compileString(String input, String includeDirName) throws JSassCompilerException {
        return this.compileString(input, "", includeDirName, false);
    }

    public String compileString(String input, String inputFileName, String includeDirName, boolean generateSourceMap) throws JSassCompilerException {
        return this.compileString(input, inputFileName, includeDirName, generateSourceMap, "");
    }

    public String compileString(String input, String inputFileName, String includeDirName, boolean generateSourceMap, String sourceMapFileName) throws JSassCompilerException {
        try {
            int index;
            if (inputFileName == null || inputFileName.equals("")) {
                inputFileName = this._tmpDirName + File.separator + "tmp.scss";
                if (generateSourceMap) {
                    System.out.println("Source maps require a valid file name");
                    generateSourceMap = false;
                }
            }
            if ((index = inputFileName.lastIndexOf(File.separatorChar)) == -1 && File.separatorChar != '/') {
                index = inputFileName.lastIndexOf(47);
            }
            String dirName = inputFileName.substring(0, ++index);
            String fileName = inputFileName.substring(index);
            String outputFileName = this.getOutputFileName(fileName);
            if (sourceMapFileName == null || sourceMapFileName.equals("")) {
                sourceMapFileName = dirName + outputFileName + ".map";
            }
            File tempFile = new File(dirName, "tmp.scss");
            tempFile.deleteOnExit();
            this.write(tempFile, input);
            String output = this.compileFile(tempFile.getCanonicalPath(), includeDirName, generateSourceMap, sourceMapFileName);
            if (generateSourceMap) {
                File sourceMapFile = new File(sourceMapFileName);
                String sourceMapContent = new String(Files.readAllBytes(sourceMapFile.toPath()));
                sourceMapContent = sourceMapContent.replaceAll("tmp\\.scss", fileName);
                sourceMapContent = sourceMapContent.replaceAll("tmp\\.css", outputFileName);
                this.write(sourceMapFile, sourceMapContent);
            }
            return output;
        }
        catch (Throwable t) {
            throw new JSassCompilerException(t);
        }
    }

    protected String getOutputFileName(String fileName) {
        return fileName.replaceAll("scss$", "css");
    }

    protected void write(File file, String string) throws IOException {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            parentFile.mkdirs();
            file.createNewFile();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8");){
            writer.write(string);
        }
    }
}

