/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.cluster;

import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import com.typesafe.config.Config;
import play.api.Environment;
import play.api.Mode;
import scala.Function0;
import scala.Serializable;
import scala.concurrent.Future$;

public final class JoinClusterImpl$ {
    public static JoinClusterImpl$ MODULE$;

    static {
        new JoinClusterImpl$();
    }

    public void join(ActorSystem system, Environment environment) {
        Config config = system.settings().config();
        boolean joinSelf = config.getBoolean("lagom.cluster.join-self");
        boolean exitJvm = config.getBoolean("lagom.cluster.exit-jvm-when-system-terminated");
        Mode mode = environment.mode();
        Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
        boolean isProd = !(mode != null ? !mode.equals(prod$) : prod$ != null);
        Cluster cluster = (Cluster)Cluster$.MODULE$.apply(system);
        if (isProd && joinSelf) {
            system.log().warning("The \"lagom.cluster.join-self\" setting should not be enabled in production, because it can conflict with Akka Cluster Bootstrap or cause split-brain clusters.");
        }
        if (cluster.settings().SeedNodes().isEmpty() && joinSelf) {
            cluster.join(cluster.selfAddress());
        }
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(system)).addTask(CoordinatedShutdown$.MODULE$.PhaseClusterShutdown(), "exit-jvm-when-downed", (Function0 & java.io.Serializable & Serializable)() -> {
            block0: {
                boolean reasonIsDowning = ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(system)).shutdownReason().contains((Object)CoordinatedShutdown.ClusterDowningReason$.MODULE$);
                if (!exitJvm || !reasonIsDowning) break block0;
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        System.exit(-1);
                    }
                });
                t.setDaemon(true);
                t.start();
            }
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
    }

    private JoinClusterImpl$() {
        MODULE$ = this;
    }
}

