/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.cluster;

import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import akka.actor.ExtendedActorSystem;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import com.lightbend.lagom.internal.akka.management.AkkaManagementTrigger;
import com.typesafe.config.Config;
import java.io.Serializable;
import play.api.Environment;
import play.api.Mode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;

public final class JoinClusterImpl$ {
    public static JoinClusterImpl$ MODULE$;

    static {
        new JoinClusterImpl$();
    }

    public void join(ActorSystem system, Environment environment, AkkaManagementTrigger akkaManagementTrigger) {
        Config config = system.settings().config();
        boolean joinSelf = config.getBoolean("lagom.cluster.join-self");
        boolean clusterBootstrapEnabled = config.getBoolean("lagom.cluster.bootstrap.enabled");
        boolean exitJvm = config.getBoolean("lagom.cluster.exit-jvm-when-system-terminated");
        Mode mode = environment.mode();
        Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
        boolean isProd = !(mode != null ? !mode.equals(prod$) : prod$ != null);
        Cluster cluster = (Cluster)Cluster$.MODULE$.apply(system);
        if (isProd && joinSelf) {
            system.log().warning("The \"lagom.cluster.join-self\" setting should not be enabled in production, because it can conflict with Akka Cluster Bootstrap or cause split-brain clusters.");
        }
        if (clusterBootstrapEnabled && joinSelf) {
            throw new IllegalArgumentException("Both \"lagom.cluster.bootstrap.enabled\" and \"lagom.cluster.join-self\" are enabled, you should enable only one. Typically, \"lagom.cluster.bootstrap.enabled\" should be used in production while \"lagom.cluster.join-self\" in development and test environments");
        }
        if (cluster.settings().SeedNodes().isEmpty()) {
            if (clusterBootstrapEnabled) {
                akkaManagementTrigger.forcedStart("Akka Cluster Bootstrap");
                ((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply((ActorSystem)((ExtendedActorSystem)system))).start();
            } else if (joinSelf) {
                cluster.join(cluster.selfAddress());
            }
        }
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(system)).addTask(CoordinatedShutdown$.MODULE$.PhaseClusterShutdown(), "exit-jvm-when-downed", (Function0 & Serializable & scala.Serializable)() -> {
            block0: {
                Option shutdownReason = ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(system)).shutdownReason();
                Seq reasons = (Seq)new .colon.colon((Object)CoordinatedShutdown.ClusterDowningReason$.MODULE$, (List)new .colon.colon((Object)CoordinatedShutdown.ClusterJoinUnsuccessfulReason$.MODULE$, (List)new .colon.colon((Object)CoordinatedShutdown.IncompatibleConfigurationDetectedReason$.MODULE$, (List)Nil$.MODULE$)));
                boolean reasonIsDowning = shutdownReason.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)reasons.contains(elem)));
                if (!exitJvm || !reasonIsDowning) break block0;
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        System.exit(-1);
                    }
                });
                t.setDaemon(true);
                t.start();
            }
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
    }

    private JoinClusterImpl$() {
        MODULE$ = this;
    }
}

