/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.javadsl.api;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.sys.package$;

public final class MethodRefResolver$ {
    public static MethodRefResolver$ MODULE$;

    static {
        new MethodRefResolver$();
    }

    public Method resolveMethodRef(Object lambda) {
        SerializedLambda serializedLambda;
        Method method;
        Class<?> lambdaType = lambda.getClass();
        if (!Serializable.class.isInstance(lambda)) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Can only resolve method references from serializable SAMs, class was: ").append(lambdaType).toString());
        }
        try {
            method = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodError e) {
            throw new IllegalArgumentException("Passed in object does not provide a writeReplace method, hence it can't be a Java 8 method reference.", e);
        }
        Method writeReplace = method;
        writeReplace.setAccessible(true);
        Object object = writeReplace.invoke(lambda, new Object[0]);
        if (!(object instanceof SerializedLambda)) {
            throw new IllegalArgumentException("Passed in object does not writeReplace itself with SerializedLambda, hence it can't be a Java 8 method reference.");
        }
        SerializedLambda serializedLambda2 = serializedLambda = (SerializedLambda)object;
        SerializedLambda serializedLambda3 = serializedLambda2;
        Class<?> ownerClass = this.loadClass(lambdaType.getClassLoader(), serializedLambda3.getImplClass());
        List<Class<?>> argumentClasses = this.getArgumentClasses(lambdaType.getClassLoader(), serializedLambda3.getImplMethodSignature());
        if (serializedLambda3.getImplClass().equals("<init>")) {
            throw new IllegalArgumentException("Passed in method ref is a constructor.");
        }
        return ownerClass.getDeclaredMethod(serializedLambda3.getImplMethodName(), (Class[])argumentClasses.toArray(ClassTag$.MODULE$.apply(Class.class)));
    }

    private Class<?> loadClass(ClassLoader classLoader, String internalName) {
        return Class.forName(internalName.replace('/', '.'), false, classLoader);
    }

    private List<Class<?>> getArgumentClasses(ClassLoader classLoader, String methodDescriptor) {
        return this.parseArgumentClasses$1(1, 0, methodDescriptor, classLoader);
    }

    private final List parseArgumentClasses$1(int offset, int arrayDepth, String methodDescriptor$1, ClassLoader classLoader$1) {
        Nil$ nil$;
        block15: while (true) {
            char c = methodDescriptor$1.charAt(offset);
            switch (c) {
                case ')': {
                    nil$ = Nil$.MODULE$;
                    break block15;
                }
                case 'L': {
                    int end = methodDescriptor$1.indexOf(59, offset);
                    String className = arrayDepth > 0 ? methodDescriptor$1.substring(offset - arrayDepth, end) : methodDescriptor$1.substring(offset + 1, end);
                    Class<?> clazz = this.loadClass(classLoader$1, className);
                    nil$ = this.parseArgumentClasses$1(end + 1, 0, methodDescriptor$1, classLoader$1).$colon$colon(clazz);
                    break block15;
                }
                case '[': {
                    ++arrayDepth;
                    ++offset;
                    continue block15;
                }
                default: {
                    Class<Comparable<Boolean>> clazz;
                    Class<Comparable<Boolean>> clazz2;
                    if (arrayDepth > 0) {
                        String className = methodDescriptor$1.substring(offset - arrayDepth, offset + 1);
                        Class<?> clazz3 = this.loadClass(classLoader$1, className);
                        nil$ = this.parseArgumentClasses$1(offset + 1, 0, methodDescriptor$1, classLoader$1).$colon$colon(clazz3);
                        break block15;
                    }
                    char c2 = c;
                    switch (c2) {
                        case 'Z': {
                            clazz2 = Boolean.TYPE;
                            break;
                        }
                        case 'C': {
                            clazz2 = Character.TYPE;
                            break;
                        }
                        case 'B': {
                            clazz2 = Byte.TYPE;
                            break;
                        }
                        case 'S': {
                            clazz2 = Short.TYPE;
                            break;
                        }
                        case 'I': {
                            clazz2 = Integer.TYPE;
                            break;
                        }
                        case 'F': {
                            clazz2 = Float.TYPE;
                            break;
                        }
                        case 'J': {
                            clazz2 = Long.TYPE;
                            break;
                        }
                        case 'D': {
                            clazz2 = Double.TYPE;
                            break;
                        }
                        default: {
                            throw package$.MODULE$.error(new StringBuilder(24).append("Unknown primitive type: ").append(c2).toString());
                        }
                    }
                    Class<Comparable<Boolean>> clazz4 = clazz = clazz2;
                    nil$ = this.parseArgumentClasses$1(offset + 1, 0, methodDescriptor$1, classLoader$1).$colon$colon(clazz4);
                    break block15;
                }
            }
            break;
        }
        return nil$;
    }

    private MethodRefResolver$() {
        MODULE$ = this;
    }
}

