/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.deser;

import com.lightbend.lagom.internal.javadsl.api.UnresolvedCollectionPathParamSerializer;
import com.lightbend.lagom.internal.javadsl.api.UnresolvedListPathParamSerializer;
import com.lightbend.lagom.internal.javadsl.api.UnresolvedOptionalPathParamSerializer;
import com.lightbend.lagom.internal.javadsl.api.UnresolvedSetPathParamSerializer;
import com.lightbend.lagom.javadsl.api.deser.PathParamSerializer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pcollections.PSequence;
import org.pcollections.TreePVector;

public final class PathParamSerializers {
    public static final PathParamSerializer<String> STRING = PathParamSerializers.required("String", Function.identity(), Function.identity());
    public static final PathParamSerializer<Long> LONG = PathParamSerializers.required("Long", Long::parseLong, l -> l.toString());
    public static final PathParamSerializer<Integer> INTEGER = PathParamSerializers.required("Integer", Integer::parseInt, n -> n.toString());
    public static final PathParamSerializer<Double> DOUBLE = PathParamSerializers.required("Double", Double::parseDouble, d -> d.toString());
    public static final PathParamSerializer<Boolean> BOOLEAN = PathParamSerializers.required("Boolean", Boolean::parseBoolean, bl -> bl.toString());
    public static final PathParamSerializer<UUID> UUID = PathParamSerializers.required("UUID", UUID::fromString, uUID -> uUID.toString());
    public static final PathParamSerializer<Optional<Object>> OPTIONAL = new UnresolvedOptionalPathParamSerializer<Object>();
    public static final PathParamSerializer<List<Object>> LIST = new UnresolvedListPathParamSerializer<Object>();
    public static final PathParamSerializer<Set<Object>> SET = new UnresolvedSetPathParamSerializer<Object>();
    public static final PathParamSerializer<Collection<Object>> COLLECTION = new UnresolvedCollectionPathParamSerializer<Object>();

    private PathParamSerializers() {
    }

    public static <Param> PathParamSerializer<Param> required(final String string, final Function<String, Param> function, final Function<Param, String> function2) {
        return new NamedPathParamSerializer<Param>(string){

            @Override
            public PSequence<String> serialize(Param Param) {
                return TreePVector.singleton(function2.apply(Param));
            }

            @Override
            public Param deserialize(PSequence<String> pSequence) {
                if (pSequence.isEmpty()) {
                    throw new IllegalArgumentException(string + " parameter is required");
                }
                return function.apply(pSequence.get(0));
            }
        };
    }

    public static <Param> PathParamSerializer<Optional<Param>> optional(String string, final Function<String, Param> function, final Function<Param, String> function2) {
        return new NamedPathParamSerializer<Optional<Param>>("Optional(" + string + ")"){

            @Override
            public PSequence<String> serialize(Optional<Param> optional) {
                return (PSequence)optional.map(object -> TreePVector.singleton(function2.apply(object))).orElse(TreePVector.empty());
            }

            @Override
            public Optional<Param> deserialize(PSequence<String> pSequence) {
                if (pSequence.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(function.apply(pSequence.get(0)));
            }
        };
    }

    private static <Param> Stream<String> serializeCollection(Collection<Param> collection, Function<Param, PSequence<String>> function) {
        return collection.stream().flatMap(object -> ((PSequence)function.apply(object)).stream());
    }

    private static <Param> Stream<Param> deserializeCollection(PSequence<String> pSequence, Function<PSequence<String>, Param> function) {
        return pSequence.stream().map(string -> function.apply((PSequence<String>)TreePVector.singleton((Object)string)));
    }

    public static <Param> PathParamSerializer<List<Param>> list(String string, final Function<PSequence<String>, Param> function, final Function<Param, PSequence<String>> function2) {
        return new NamedPathParamSerializer<List<Param>>("List(" + string + ")"){

            @Override
            public PSequence<String> serialize(List<Param> list) {
                List list2 = PathParamSerializers.serializeCollection(list, function2).collect(Collectors.toList());
                return TreePVector.from(list2);
            }

            @Override
            public List<Param> deserialize(PSequence<String> pSequence) {
                return PathParamSerializers.deserializeCollection((PSequence<String>)pSequence, function).collect(Collectors.toList());
            }
        };
    }

    public static <Param> PathParamSerializer<Set<Param>> set(String string, final Function<PSequence<String>, Param> function, final Function<Param, PSequence<String>> function2) {
        return new NamedPathParamSerializer<Set<Param>>("Set(" + string + ")"){

            @Override
            public PSequence<String> serialize(Set<Param> set) {
                Set set2 = PathParamSerializers.serializeCollection(set, function2).collect(Collectors.toSet());
                return TreePVector.from(set2);
            }

            @Override
            public Set<Param> deserialize(PSequence<String> pSequence) {
                return PathParamSerializers.deserializeCollection((PSequence<String>)pSequence, function).collect(Collectors.toSet());
            }
        };
    }

    public static <Param> PathParamSerializer<Collection<Param>> collection(String string, final Function<PSequence<String>, Param> function, final Function<Param, PSequence<String>> function2) {
        return new NamedPathParamSerializer<Collection<Param>>("Collection(" + string + ")"){

            @Override
            public PSequence<String> serialize(Collection<Param> collection) {
                Collection collection2 = PathParamSerializers.serializeCollection(collection, function2).collect(Collectors.toList());
                return TreePVector.from((Collection)collection2);
            }

            @Override
            public Collection<Param> deserialize(PSequence<String> pSequence) {
                return PathParamSerializers.deserializeCollection((PSequence<String>)pSequence, function).collect(Collectors.toList());
            }
        };
    }

    private static abstract class NamedPathParamSerializer<Param>
    implements PathParamSerializer<Param> {
        private final String name;

        public NamedPathParamSerializer(String string) {
            this.name = string;
        }

        public String toString() {
            return "PathParamSerializer(" + this.name + ")";
        }
    }
}

