/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.deser;

import akka.util.ByteString;
import com.lightbend.lagom.javadsl.api.transport.MessageProtocol;
import com.lightbend.lagom.javadsl.api.transport.TransportErrorCode;
import java.util.Base64;

public class RawExceptionMessage {
    private final TransportErrorCode errorCode;
    private final MessageProtocol protocol;
    private final ByteString message;

    public RawExceptionMessage(TransportErrorCode transportErrorCode, MessageProtocol messageProtocol, ByteString byteString) {
        this.errorCode = transportErrorCode;
        this.protocol = messageProtocol;
        this.message = byteString;
    }

    public TransportErrorCode errorCode() {
        return this.errorCode;
    }

    public MessageProtocol protocol() {
        return this.protocol;
    }

    public ByteString message() {
        return this.message;
    }

    public String messageAsText() {
        if (this.protocol.charset().isPresent()) {
            return this.message.decodeString(this.protocol.charset().get());
        }
        return Base64.getEncoder().encodeToString(this.message.toArray());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RawExceptionMessage rawExceptionMessage = (RawExceptionMessage)object;
        if (!this.errorCode.equals(rawExceptionMessage.errorCode)) {
            return false;
        }
        if (!this.protocol.equals(rawExceptionMessage.protocol)) {
            return false;
        }
        return this.message.equals((Object)rawExceptionMessage.message);
    }

    public int hashCode() {
        int n = this.errorCode.hashCode();
        n = 31 * n + this.protocol.hashCode();
        n = 31 * n + this.message.hashCode();
        return n;
    }

    public String toString() {
        return "RawExceptionMessage{errorCode=" + this.errorCode + ", protocol=" + this.protocol + ", message=" + this.message + '}';
    }
}

