/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.transport;

import com.lightbend.lagom.internal.api.HeaderUtils;
import com.lightbend.lagom.javadsl.api.transport.MessageProtocol;
import java.util.Map;
import java.util.Optional;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import org.pcollections.PSequence;

public abstract class MessageHeader {
    protected final MessageProtocol protocol;
    protected final PMap<String, PSequence<String>> headers;
    protected final PMap<String, PSequence<String>> lowercaseHeaders;

    MessageHeader(MessageProtocol messageProtocol, PMap<String, PSequence<String>> pMap, PMap<String, PSequence<String>> pMap2) {
        this.protocol = messageProtocol;
        this.headers = pMap;
        this.lowercaseHeaders = pMap2;
    }

    MessageHeader(MessageProtocol messageProtocol, PMap<String, PSequence<String>> pMap) {
        this.protocol = messageProtocol;
        this.headers = pMap;
        HashPMap hashPMap = HashTreePMap.empty();
        for (Map.Entry entry : pMap.entrySet()) {
            hashPMap = hashPMap.plus((Object)HeaderUtils.normalize((String)((String)entry.getKey())), (Object)((PSequence)entry.getValue()));
        }
        this.lowercaseHeaders = hashPMap;
    }

    public MessageProtocol protocol() {
        return this.protocol;
    }

    public PMap<String, PSequence<String>> headers() {
        return this.headers;
    }

    public Optional<String> getHeader(String string) {
        PSequence pSequence = (PSequence)this.lowercaseHeaders.get((Object)HeaderUtils.normalize((String)string));
        if (pSequence == null || pSequence.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((String)pSequence.get(0));
    }

    public abstract MessageHeader withProtocol(MessageProtocol var1);

    public abstract MessageHeader replaceAllHeaders(PMap<String, PSequence<String>> var1);

    public abstract MessageHeader withHeader(String var1, String var2);
}

