/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api.transport;

import java.nio.charset.Charset;
import java.util.Optional;

public final class MessageProtocol {
    private final Optional<String> contentType;
    private final Optional<String> charset;
    private final Optional<String> version;
    private static final Charset utf8Charset = Charset.forName("utf-8");

    public MessageProtocol(Optional<String> optional, Optional<String> optional2, Optional<String> optional3) {
        this.contentType = optional;
        this.charset = optional2;
        this.version = optional3;
    }

    public MessageProtocol() {
        this.contentType = Optional.empty();
        this.charset = Optional.empty();
        this.version = Optional.empty();
    }

    public Optional<String> contentType() {
        return this.contentType;
    }

    public Optional<String> charset() {
        return this.charset;
    }

    public Optional<String> version() {
        return this.version;
    }

    public MessageProtocol withContentType(String string) {
        return new MessageProtocol(Optional.ofNullable(string), this.charset, this.version);
    }

    public MessageProtocol withCharset(String string) {
        return new MessageProtocol(this.contentType, Optional.ofNullable(string), this.version);
    }

    public MessageProtocol withVersion(String string) {
        return new MessageProtocol(this.contentType, this.charset, Optional.ofNullable(string));
    }

    public boolean isText() {
        boolean bl = this.contentType.map(string -> "application/json".equals(string)).orElse(false);
        boolean bl2 = this.contentType.map(string -> "text/plain".equals(string)).orElse(false);
        return this.charset.isPresent() || bl || bl2;
    }

    public boolean isUtf8() {
        if (this.charset.isPresent()) {
            return utf8Charset.equals(Charset.forName(this.charset.get()));
        }
        return false;
    }

    public Optional<String> toContentTypeHeader() {
        return this.contentType.map(string -> {
            if (this.charset.isPresent()) {
                return string + "; charset=" + this.charset.get();
            }
            return string;
        });
    }

    public static MessageProtocol fromContentTypeHeader(Optional<String> optional) {
        return optional.map(string -> {
            String[] stringArray = string.split(";");
            String string2 = stringArray[0];
            Optional<String> optional = Optional.empty();
            for (int i = 1; i < stringArray.length; ++i) {
                String string3 = stringArray[i].trim();
                if (!string3.startsWith("charset=")) continue;
                optional = Optional.of(string3.split("=", 2)[1]);
                break;
            }
            return new MessageProtocol(Optional.of(string2), optional, Optional.empty());
        }).orElse(new MessageProtocol());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MessageProtocol messageProtocol = (MessageProtocol)object;
        if (!this.contentType.equals(messageProtocol.contentType)) {
            return false;
        }
        if (!this.charset.equals(messageProtocol.charset)) {
            return false;
        }
        return this.version.equals(messageProtocol.version);
    }

    public int hashCode() {
        int n = this.contentType.hashCode();
        n = 31 * n + this.charset.hashCode();
        n = 31 * n + this.version.hashCode();
        return n;
    }

    public String toString() {
        return "MessageProtocol{contentType=" + this.contentType + ", charset=" + this.charset + ", version=" + this.version + '}';
    }
}

